/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl;

import java.util.Hashtable;

public final class Utilites {
    public static void parseInfo(String infoStr, Hashtable infoTable) {
        String[] tmp = new String[]{infoStr};
        do {
            String k = Utilites.extractString(tmp);
            if (tmp[0] == null) {
                throw new IllegalArgumentException("Invalid infoStr format: " + infoStr);
            }
            String v = Utilites.extractString(tmp);
            infoTable.put(k, v);
        } while (tmp[0] != null);
    }

    public static boolean getBooleanProperty(String cn, Hashtable props, String pName, boolean defaultValue) {
        boolean res = defaultValue;
        String str = (String)props.get(pName);
        if (str == null) {
            System.err.println(cn + ": Internal error: Can't get property: " + pName);
        } else if (str.equals("true")) {
            res = true;
        } else if (str.equals("false")) {
            res = false;
        } else {
            System.err.println(cn + ": Internal error: wrong value: " + pName + "=" + str);
        }
        return res;
    }

    public static int getIntProperty(String cn, Hashtable props, String pName, int radix, int defaultValue) {
        int res = defaultValue;
        String str = (String)props.get(pName);
        if (str == null) {
            System.err.println(cn + ": Internal error: Can't get property: " + pName);
        } else {
            try {
                res = Integer.parseInt(str, radix);
            }
            catch (NumberFormatException e) {
                System.err.println(cn + ": Internal error: wrong value: " + pName + "=" + str);
            }
        }
        if (res < 0) {
            res = defaultValue;
        }
        return res;
    }

    public static int getIntProperty(String cn, Hashtable props, String pName, int defaultValue) {
        return Utilites.getIntProperty(cn, props, pName, 10, defaultValue);
    }

    public static String[] splitString(String str, char sep) {
        int nItems = 1;
        int index = 0;
        while ((index = str.indexOf(sep, index)) != -1) {
            if (index == str.length() - 1 || index == 0) {
                throw new IllegalArgumentException("Str is bounded by separator.");
            }
            ++index;
            ++nItems;
        }
        String[] res = new String[nItems];
        for (int i = 0; i < nItems - 1; ++i) {
            res[i] = str.substring(0, str.indexOf(sep));
            str = str.substring(str.indexOf(sep) + 1);
        }
        res[res.length - 1] = str;
        return res;
    }

    public static boolean checkBluetoothAddress(String address) {
        if (address == null) {
            return false;
        }
        if (address.length() != 12 || address.indexOf(45) != -1) {
            return false;
        }
        try {
            Long.parseLong(address, 16);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static String extractString(String[] str) {
        int separator = 10;
        String s = str[0];
        int i = s.indexOf(10);
        if (i >= 1) {
            str[0] = i != s.length() - 1 ? s.substring(i + 1, s.length()) : null;
            return s.substring(0, i);
        }
        return null;
    }
}

