/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.SDPClient;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceSearcherBase;
import java.io.IOException;
import java.util.Hashtable;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

class ServiceSearcher
extends ServiceSearcherBase {
    private static final boolean DEBUG = false;
    private static final String cn = "ServiceSearcher";
    private short transactionID;
    private DiscoveryListener discListener;
    private SDPClient sdp;
    private int[] handles;
    private int processedHandle;
    private boolean inactive = false;
    private static int requestCounter = 0;
    private static Hashtable searchers = new Hashtable();
    static /* synthetic */ Class class$com$sun$kvem$jsr082$bluetooth$ServiceSearcher;

    ServiceSearcher(int[] attrSet, UUID[] uuidSet, RemoteDevice btDev, DiscoveryListener discListener) {
        super(attrSet, uuidSet, btDev);
        if (discListener == null) {
            throw new NullPointerException("null instance of DiscoveryListener");
        }
        this.discListener = discListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int start() throws BluetoothStateException {
        Class clazz = class$com$sun$kvem$jsr082$bluetooth$ServiceSearcher == null ? (class$com$sun$kvem$jsr082$bluetooth$ServiceSearcher = ServiceSearcher.class$("com.sun.kvem.jsr082.bluetooth.ServiceSearcher")) : class$com$sun$kvem$jsr082$bluetooth$ServiceSearcher;
        synchronized (clazz) {
            if (requestCounter == ServiceRecordImpl.TRANS_MAX) {
                throw new BluetoothStateException("too mach concurent requests");
            }
            ++requestCounter;
        }
        this.transactionID = SDPClient.newTransactionID();
        ServiceSearcher.cancel(this.transactionID);
        searchers.put(new Integer(this.transactionID), this);
        try {
            this.sdp = new SDPClient(this.btDev.getBluetoothAddress());
            this.sdp.serviceSearchRequest(this.uuidSet, this.transactionID, this);
        }
        catch (IOException ioe) {
            ServiceSearcher serviceSearcher = this;
            synchronized (serviceSearcher) {
                this.stop();
                new NotifyListenerRunner(6);
                return this.transactionID;
            }
        }
        return this.transactionID;
    }

    public void errorResponse(int errorCode, String info, int transactionID) {
        this.stop();
        if (errorCode == 1 || errorCode == 3 || errorCode == 4 || errorCode == 5 || errorCode == 6) {
            this.notifyListener(3);
            System.err.println(info);
        } else if (errorCode == 2) {
            this.notifyListener(4);
            System.err.println(info);
        } else if (errorCode == 65536) {
            this.notifyListener(6);
        } else if (errorCode == 65537) {
            new NotifyListenerRunner(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchResponse(int[] handleList, int transactionID) {
        if (handleList == null || handleList.length == 0) {
            this.stop();
            this.notifyListener(4);
            return;
        }
        ServiceSearcher serviceSearcher = this;
        synchronized (serviceSearcher) {
            this.handles = handleList;
            this.processedHandle = 0;
        }
        try {
            this.sdp.serviceAttributeRequest(this.handles[this.processedHandle], this.attrSet, transactionID, this);
        }
        catch (IOException ioe) {
            this.stop();
            this.notifyListener(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceAttributeResponse(int[] attrIDs, DataElement[] attributeValues, int transactionID) {
        ServiceSearcher serviceSearcher = this;
        synchronized (serviceSearcher) {
            ++this.processedHandle;
        }
        if (attributeValues != null) {
            ServiceRecord[] serviceRecordSet = new ServiceRecordImpl[]{new ServiceRecordImpl(this.btDev, attrIDs, attributeValues)};
            try {
                this.discListener.servicesDiscovered((int)this.transactionID, serviceRecordSet);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.processedHandle == this.handles.length) {
            this.stop();
            this.notifyListener(1);
            return;
        }
        try {
            this.sdp.serviceAttributeRequest(this.handles[this.processedHandle], this.attrSet, transactionID, this);
        }
        catch (IOException ioe) {
            this.stop();
            this.notifyListener(6);
        }
    }

    public void serviceSearchAttributeResponse(int[] attrIDs, DataElement[] attributeValues, int transactionID) {
        throw new RuntimeException("unexpected call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        SDPClient sdp;
        SDPClient.freeTransactionID(this.transactionID);
        searchers.remove(new Integer(this.transactionID));
        Object object = this;
        synchronized (object) {
            if (this.sdp == null) {
                return;
            }
            this.inactive = true;
            sdp = this.sdp;
            this.sdp = null;
        }
        object = class$com$sun$kvem$jsr082$bluetooth$ServiceSearcher == null ? (class$com$sun$kvem$jsr082$bluetooth$ServiceSearcher = ServiceSearcher.class$("com.sun.kvem.jsr082.bluetooth.ServiceSearcher")) : class$com$sun$kvem$jsr082$bluetooth$ServiceSearcher;
        synchronized (object) {
            --requestCounter;
        }
        try {
            sdp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancel() {
        ServiceSearcher serviceSearcher = this;
        synchronized (serviceSearcher) {
            if (this.inactive) {
                return false;
            }
            this.inactive = true;
            if (this.sdp == null) {
                return false;
            }
        }
        return this.sdp.cancelServiceSearch(this.transactionID);
    }

    static boolean cancel(int transactionID) {
        ServiceSearcher carrier = (ServiceSearcher)searchers.get(new Integer(transactionID));
        if (carrier == null) {
            return false;
        }
        return carrier.cancel();
    }

    private void notifyListener(int respCode) {
        try {
            this.discListener.serviceSearchCompleted((int)this.transactionID, respCode);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NotifyListenerRunner
    implements Runnable {
        int respCode;

        NotifyListenerRunner(int respCode) {
            this.respCode = respCode;
            new Thread(this).start();
        }

        public void run() {
            ServiceSearcher.this.notifyListener(this.respCode);
        }
    }
}

