/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BluetoothNotifier;
import com.sun.kvem.jsr082.bluetooth.SDPClient;
import com.sun.kvem.jsr082.bluetooth.SDPResponseListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

public final class ServiceRecordImpl
implements ServiceRecord {
    static final int RETRIEVABLE_MAX = Integer.valueOf(LocalDevice.getProperty((String)"bluetooth.sd.attr.retrievable.max"));
    static final int TRANS_MAX = Integer.valueOf(LocalDevice.getProperty((String)"bluetooth.sd.trans.max"));
    private RemoteDevice remoteDevice = null;
    private BluetoothNotifier notifier = null;
    private Hashtable attributesTable = null;
    private int serviceClasses = 0;
    private String urlPrefix = null;
    private static final int MASK_OVERFLOW = -65536;
    private static final int MASK_INCORRECT_CLASS = -16760833;
    static final int ServiceRecordHandle = 0;
    static final int ServiceClassIDList = 1;
    static final int ServiceRecordState = 2;
    static final int ServiceID = 3;
    static final int PROTOCOL_DESCRIPTOR_LIST = 4;
    static final int BrowseGroupList = 5;
    static final int LanguageBasedAttributeIDList = 6;
    static final int ServiceInfoTimeToLive = 7;
    static final int ServiceAvailability = 8;
    static final int BluetoothProfileDescriptorList = 9;
    static final int DocumentationURL = 10;
    static final int ClientExecutableURL = 11;
    static final int IconURL = 12;
    static final int VersionNumberList = 512;
    static final int ServiceDatabaseState = 513;

    protected ServiceRecordImpl(RemoteDevice device, int[] attrIDs, DataElement[] attrValues) {
        this.init(attrIDs, attrValues);
        this.remoteDevice = device;
    }

    public ServiceRecordImpl(BluetoothNotifier notifier, int[] attrIDs, DataElement[] attrValues) {
        this.init(attrIDs, attrValues);
        this.notifier = notifier;
    }

    public ServiceRecordImpl(BluetoothNotifier notifier, int handle) {
        this.notifier = notifier;
        this.attributesTable = new Hashtable(5);
        this.setHandle(handle);
    }

    public int getHandle() {
        DataElement el = (DataElement)this.attributesTable.get(new Integer(0));
        if (el == null) {
            return -1;
        }
        return (int)el.getLong();
    }

    public void removeHandle() {
        this.attributesTable.remove(new Integer(0));
    }

    public void setHandle(int handle) {
        this.attributesTable.put(new Integer(0), new DataElement(10, (long)handle & 0xFFFFFFFFL));
    }

    public BluetoothNotifier getNotifier() {
        return this.notifier;
    }

    private void init(int[] attrIDs, DataElement[] attrValues) {
        this.attributesTable = new Hashtable(attrIDs.length + 1);
        this.attrsInit(attrIDs, attrValues);
    }

    private void attrsInit(int[] attrIDs, DataElement[] attrValues) {
        for (int i = 0; i < attrIDs.length; ++i) {
            this.attributesTable.put(new Integer(attrIDs[i]), this.dataElementCopy(attrValues[i]));
        }
    }

    private DataElement dataElementCopy(DataElement original) {
        if (original.getDataType() == 48 || original.getDataType() == 56) {
            DataElement copy = new DataElement(original.getDataType());
            Enumeration elements = (Enumeration)original.getValue();
            while (elements.hasMoreElements()) {
                copy.addElement(this.dataElementCopy((DataElement)elements.nextElement()));
            }
            return copy;
        }
        return original;
    }

    public DataElement getAttributeValue(int attrID) {
        if ((attrID & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("attrID isn't a 16-bit unsigned integer");
        }
        DataElement attrValue = (DataElement)this.attributesTable.get(new Integer(attrID));
        if (attrValue == null) {
            return null;
        }
        return this.dataElementCopy(attrValue);
    }

    public RemoteDevice getHostDevice() {
        return this.remoteDevice;
    }

    public int[] getAttributeIDs() {
        int[] attrIDs = new int[this.attributesTable.size()];
        Enumeration e = this.attributesTable.keys();
        for (int i = 0; i < attrIDs.length; ++i) {
            attrIDs[i] = (Integer)e.nextElement();
        }
        return attrIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateRecord(int[] attrIDs) throws IOException {
        Hashtable<Integer, Object> dupChecker = new Hashtable<Integer, Object>();
        Object checkObj = new Object();
        if (this.remoteDevice == null) {
            throw new RuntimeException("local ServiceRecord");
        }
        if (attrIDs.length == 0) {
            throw new IllegalArgumentException("attrIDs size is zero");
        }
        if (attrIDs.length > RETRIEVABLE_MAX) {
            throw new IllegalArgumentException("attrIDs size exceeds retrievable.max");
        }
        for (int i = 0; i < attrIDs.length; ++i) {
            if ((attrIDs[i] & 0xFFFF0000) != 0) {
                throw new IllegalArgumentException("attrID does not represent a 16-bit unsigned integer");
            }
            if (dupChecker.put(new Integer(attrIDs[i]), checkObj) == null) continue;
            throw new IllegalArgumentException("duplicated attribute ID");
        }
        short transactionID = SDPClient.newTransactionID();
        SDPClient sdp = null;
        SRSDPListener listener = null;
        try {
            DataElement handleEl = (DataElement)this.attributesTable.get(new Integer(0));
            int handle = (int)handleEl.getLong();
            listener = new SRSDPListener();
            sdp = new SDPClient(this.remoteDevice.getBluetoothAddress());
            sdp.serviceAttributeRequest(handle, attrIDs, transactionID, listener);
            SRSDPListener sRSDPListener = listener;
            synchronized (sRSDPListener) {
                if (listener.ioExcpt == null && listener.attrValues == null) {
                    try {
                        listener.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            SDPClient.freeTransactionID(transactionID);
            if (sdp != null) {
                try {
                    sdp.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (listener.ioExcpt != null) {
            throw listener.ioExcpt;
        }
        if (listener.attrValues == null) {
            return false;
        }
        if (listener.attrValues.length == 0) {
            return false;
        }
        this.attrsInit(listener.attrIDs, listener.attrValues);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public String getConnectionURL(int requiredSecurity, boolean mustBeMaster) {
        String portStr;
        void var5_5;
        String btadrr;
        StringBuffer url = new StringBuffer();
        if (mustBeMaster) {
            url.append(";master=true");
        } else {
            url.append(";master=false");
        }
        switch (requiredSecurity) {
            case 0: {
                url.append(";encrypt=false;authenticate=false");
                break;
            }
            case 1: {
                url.append(";encrypt=false;authenticate=true");
                break;
            }
            case 2: {
                url.append(";encrypt=true;authenticate=true");
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported security type: " + requiredSecurity);
            }
        }
        String tail = url.toString();
        if (this.urlPrefix != null) {
            return this.urlPrefix + tail;
        }
        if (this.remoteDevice != null) {
            btadrr = this.remoteDevice.getBluetoothAddress();
        } else {
            try {
                btadrr = LocalDevice.getLocalDevice().getBluetoothAddress();
            }
            catch (BluetoothStateException bse) {
                return null;
            }
        }
        DataElement protocolList = this.getAttributeValue(4);
        Enumeration val = (Enumeration)protocolList.getValue();
        int type = -1;
        int port = -1;
        UUID L2CAP_UUID = new UUID(256L);
        UUID RFCOMM_UUID = new UUID(3L);
        UUID OBEX_UUID = new UUID(8L);
        while (val.hasMoreElements()) {
            DataElement protoDE = (DataElement)val.nextElement();
            if (protoDE.getDataType() != 48) continue;
            Enumeration protoEnum = (Enumeration)protoDE.getValue();
            int tmpPort = -1;
            int tmpType = -1;
            while (protoEnum.hasMoreElements()) {
                DataElement de = (DataElement)protoEnum.nextElement();
                if (de.getDataType() == 8 || de.getDataType() == 9) {
                    tmpPort = (int)de.getLong();
                    continue;
                }
                if (de.getDataType() != 24) continue;
                UUID protoUUID = (UUID)de.getValue();
                if (protoUUID.equals((Object)L2CAP_UUID)) {
                    tmpType = 0;
                    continue;
                }
                if (protoUUID.equals((Object)RFCOMM_UUID)) {
                    tmpType = 1;
                    continue;
                }
                if (!protoUUID.equals((Object)OBEX_UUID)) continue;
                tmpType = 2;
            }
            if (tmpType > type) {
                type = tmpType;
                if (tmpType == 2) continue;
                port = tmpPort;
                continue;
            }
            if (tmpType != 1) continue;
            port = tmpPort;
        }
        String errorMsg = "Error: wrong protocol list";
        switch (type) {
            case 0: {
                url = new StringBuffer("btl2cap://");
                break;
            }
            case 1: {
                url = new StringBuffer("btspp://");
                break;
            }
            case 2: {
                url = new StringBuffer("btgoep://");
                break;
            }
            default: {
                System.err.println("Error: wrong protocol list");
                return null;
            }
        }
        if (type == 0 && (port < 4097 || port > 65535)) {
            System.err.println("Error: wrong protocol list");
            return null;
        }
        if (!(type != 1 && type != 2 || port > 0 && port <= 30)) {
            System.err.println("Error: wrong protocol list");
            return null;
        }
        url.append((String)var5_5).append(':');
        if (type == 0) {
            portStr = Integer.toHexString(port);
            for (int zNum = 4 - portStr.length(); zNum != 0; --zNum) {
                url.append('0');
            }
        } else {
            portStr = Integer.toString(port);
        }
        url.append(portStr);
        this.urlPrefix = url.toString();
        url.append(tail);
        return url.toString();
    }

    public int getDeviceServiceClasses() {
        if (this.remoteDevice != null) {
            throw new RuntimeException("This ServiceRecord was created by a call to DiscoveryAgent.searchServices()");
        }
        return this.serviceClasses;
    }

    public void setDeviceServiceClasses(int classes) {
        if (this.remoteDevice != null) {
            throw new RuntimeException("This ServiceRecord was created by a call to DiscoveryAgent.searchServices()");
        }
        if ((classes & 0xFF003FFF) != 0) {
            throw new IllegalArgumentException("attempt to set incorrect bits");
        }
        this.serviceClasses = classes;
    }

    public boolean setAttributeValue(int attrID, DataElement attrValue) {
        if ((attrID & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("attrID does not represent a 16-bit unsigned integer");
        }
        if (attrID == 0) {
            throw new IllegalArgumentException("attrID is the value of ServiceRecordHandle (0x0000)");
        }
        if (this.remoteDevice != null) {
            throw new RuntimeException("can't update ServiceRecord of the RemoteDevice");
        }
        Integer key = new Integer(attrID);
        if (attrValue == null) {
            return this.attributesTable.remove(key) != null;
        }
        this.attributesTable.put(key, this.dataElementCopy(attrValue));
        return true;
    }

    class SRSDPListener
    implements SDPResponseListener {
        DataElement[] attrValues = null;
        IOException ioExcpt = null;
        int[] attrIDs = null;

        SRSDPListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void errorResponse(int errorCode, String info, int transactionID) {
            SRSDPListener sRSDPListener = this;
            synchronized (sRSDPListener) {
                this.ioExcpt = new IOException(info);
                this.notify();
            }
        }

        public void serviceSearchResponse(int[] handleList, int transactionID) {
            throw new RuntimeException("unexpected call");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceAttributeResponse(int[] attributeIDs, DataElement[] attributeValues, int transactionID) {
            SRSDPListener sRSDPListener = this;
            synchronized (sRSDPListener) {
                this.attrIDs = attributeIDs;
                this.attrValues = attributeValues;
                this.notify();
            }
        }

        public void serviceSearchAttributeResponse(int[] attrIDs, DataElement[] attributeValues, int transactionID) {
            throw new RuntimeException("unexpected call");
        }
    }
}

