/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.DataL2CAPReaderWriter;
import com.sun.kvem.jsr082.bluetooth.LocalDeviceImpl;
import com.sun.kvem.jsr082.bluetooth.SDDBImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.DataElement;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.UUID;

class SDPServer {
    private static final boolean DEBUG = false;
    private SDDBImpl sddb;
    private L2CAPConnectionNotifier conNotifier = null;
    private Vector connections;
    private Acceptor acceptor;
    private boolean acceptorStarted = false;
    private static final int SDP_UUID = 1;
    private static final int SDP_ERROR_RESPONSE = 1;
    private static final int SDP_SERVICE_SEARCH_REQUEST = 2;
    private static final int SDP_SERVICE_SEARCH_RESPONSE = 3;
    private static final int SDP_SERVICE_ATTRIBUTE_REQUEST = 4;
    private static final int SDP_SERVICE_ATTRIBUTE_RESPONSE = 5;
    private static final int SDP_SERVICE_SEARCH_ATTRIBUTE_REQUEST = 6;
    private static final int SDP_SERVICE_SEARCH_ATTRIBUTE_RESPONSE = 7;
    private static final int SDP_INVALID_VERSION = 1;
    private static final int SDP_INVALID_SR_HANDLE = 2;
    private static final int SDP_INVALID_SYNTAX = 3;

    SDPServer(SDDBImpl sddb) {
        this.sddb = sddb;
        this.connections = new Vector();
        this.acceptor = new Acceptor();
    }

    synchronized void start() {
        if (this.acceptorStarted) {
            return;
        }
        UUID sdpUUID = new UUID(1L);
        try {
            BCC control = LocalDeviceImpl.getBCC();
            this.conNotifier = (L2CAPConnectionNotifier)control.getL2CAPConnection("//localhost:" + sdpUUID.toString() + ";name=SDPServer");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.conNotifier != null) {
            this.acceptorStarted = true;
            new Thread(this.acceptor).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stop() {
        try {
            this.conNotifier.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        for (int i = this.connections.size(); i >= 0; --i) {
            L2CAPConnection con = (L2CAPConnection)this.connections.elementAt(i);
            try {
                L2CAPConnection l2CAPConnection = con;
                synchronized (l2CAPConnection) {
                    con.close();
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.connections.removeAllElements();
    }

    private void processRequest(DataL2CAPReaderWriter rw) throws IOException {
        byte requestType = rw.readByte();
        short transactionID = rw.readShort();
        short length = rw.readShort();
        if (requestType == 2) {
            this.processServiceSearch(rw, transactionID);
        } else if (requestType == 4) {
            this.processServiceAttribute(rw, transactionID);
        } else if (requestType == 6) {
            this.processServiceSearchAttribute(rw, transactionID);
        } else {
            this.writeErrorResponce(rw, transactionID, 3, "Invalid Type of Request");
            System.err.println("WARNING: Unsupported SDP request");
        }
    }

    private void processServiceSearch(DataL2CAPReaderWriter rw, short transactionID) throws IOException {
        int i;
        DataElement uuidSet = rw.readDataElement();
        short maximimSRCount = rw.readShort();
        byte continuationState = rw.readByte();
        if (continuationState != 0) {
            this.writeErrorResponce(rw, transactionID, 1, "Current implementation don't support continuation state");
            return;
        }
        Vector<Integer> currentHandles = new Vector<Integer>();
        int[] handles = this.sddb.getHandles();
        for (i = 0; i < handles.length; ++i) {
            ServiceRecordImpl sr = this.sddb.getServiceRecord(handles[i]);
            if (!this.findUUIDs(sr, uuidSet)) continue;
            currentHandles.addElement(new Integer(handles[i]));
        }
        rw.writeByte(3L);
        rw.writeShort(transactionID);
        rw.writeShort((short)(currentHandles.size() + 5));
        rw.writeShort((short)handles.length);
        rw.writeShort((short)currentHandles.size());
        for (i = 0; i < currentHandles.size() && i <= maximimSRCount; ++i) {
            int h = (Integer)currentHandles.elementAt(i);
            rw.writeInteger(h);
        }
        rw.writeByte(0L);
        rw.flush();
    }

    private void processServiceAttribute(DataL2CAPReaderWriter rw, short transactionID) throws IOException {
        int handle = rw.readInteger();
        short maximimSize = rw.readShort();
        DataElement attrSet = rw.readDataElement();
        byte continuationState = rw.readByte();
        if (continuationState != 0) {
            this.writeErrorResponce(rw, transactionID, 1, "Current implementation don't support continuation state");
            return;
        }
        ServiceRecordImpl sr = this.sddb.getServiceRecord(handle);
        if (sr == null) {
            this.writeErrorResponce(rw, transactionID, 2, "Servicce Record with specified ID not found");
            return;
        }
        DataElement attrIDValues = new DataElement(48);
        Enumeration e = (Enumeration)attrSet.getValue();
        while (e.hasMoreElements()) {
            DataElement attrID = (DataElement)e.nextElement();
            int attr = (int)attrID.getLong();
            DataElement attrValue = sr.getAttributeValue(attr);
            if (attrValue == null) continue;
            attrIDValues.addElement(attrID);
            attrIDValues.addElement(attrValue);
        }
        int length = (int)rw.getDataSize(attrIDValues);
        rw.writeByte(5L);
        rw.writeShort(transactionID);
        rw.writeShort((short)(length + 3));
        rw.writeShort((short)length);
        rw.writeDataElement(attrIDValues);
        rw.writeByte(0L);
        rw.flush();
    }

    private void processServiceSearchAttribute(DataL2CAPReaderWriter rw, short transactionID) throws IOException {
        DataElement uuidSet = rw.readDataElement();
        short maximimSize = rw.readShort();
        DataElement attrSet = rw.readDataElement();
        byte continuationState = rw.readByte();
        if (continuationState != 0) {
            this.writeErrorResponce(rw, transactionID, 1, "Current implementation don't support continuation state");
            return;
        }
        int[] handles = this.sddb.getHandles();
        int handle = -1;
        for (int i = 0; i < handles.length; ++i) {
            ServiceRecordImpl sr = this.sddb.getServiceRecord(handles[i]);
            if (!this.findUUIDs(sr, uuidSet)) continue;
            handle = handles[i];
        }
        ServiceRecordImpl sr = this.sddb.getServiceRecord(handle);
        if (sr == null) {
            this.writeErrorResponce(rw, transactionID, 2, "Servicce Record with specified ID not found");
            return;
        }
        DataElement attrIDValues = new DataElement(48);
        Enumeration e = (Enumeration)attrSet.getValue();
        while (e.hasMoreElements()) {
            DataElement attrID = (DataElement)e.nextElement();
            int attr = (int)attrID.getLong();
            DataElement attrValue = sr.getAttributeValue(attr);
            if (attrValue == null) continue;
            attrIDValues.addElement(attrID);
            attrIDValues.addElement(attrValue);
        }
        int length = (int)rw.getDataSize(attrIDValues);
        rw.writeByte(7L);
        rw.writeShort(transactionID);
        rw.writeShort((short)(length + 3));
        rw.writeShort((short)length);
        rw.writeDataElement(attrIDValues);
        rw.writeByte(0L);
        rw.flush();
    }

    private void writeErrorResponce(DataL2CAPReaderWriter rw, short transactionID, int errorCode, String info) throws IOException {
        byte[] infoBytes = info.getBytes();
        int length = infoBytes.length + 2;
        rw.writeByte(1L);
        rw.writeShort(transactionID);
        rw.writeShort((short)length);
        rw.writeShort((short)errorCode);
        rw.writeBytes(infoBytes);
        rw.flush();
    }

    private boolean findUUIDs(ServiceRecordImpl sr, DataElement uuids) {
        int[] attrs = sr.getAttributeIDs();
        Enumeration e = (Enumeration)uuids.getValue();
        block0: while (e.hasMoreElements()) {
            UUID uuid = (UUID)((DataElement)e.nextElement()).getValue();
            for (int i = 0; i < attrs.length; ++i) {
                DataElement attr = sr.getAttributeValue(attrs[i]);
                if (this.containsUUID(attr, uuid)) continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean containsUUID(DataElement attr, UUID uuid) {
        if (attr.getDataType() == 24) {
            return uuid.equals((Object)((UUID)attr.getValue()));
        }
        if (attr.getDataType() != 48) {
            return false;
        }
        Enumeration e = (Enumeration)attr.getValue();
        while (e.hasMoreElements()) {
            DataElement de = (DataElement)e.nextElement();
            if (!this.containsUUID(de, uuid)) continue;
            return true;
        }
        return false;
    }

    class Sender
    implements Runnable {
        L2CAPConnection connection;
        DataL2CAPReaderWriter readerWriter;

        Sender(L2CAPConnection connection, DataL2CAPReaderWriter readerWriter) {
            this.connection = connection;
            this.readerWriter = readerWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    SDPServer.this.processRequest(this.readerWriter);
                }
            }
            catch (IOException ioe) {
                SDPServer sDPServer = SDPServer.this;
                synchronized (sDPServer) {
                    SDPServer.this.connections.removeElement(this.connection);
                }
                try {
                    this.connection.close();
                }
                catch (IOException iOException) {}
                return;
            }
        }
    }

    class Acceptor
    implements Runnable {
        Acceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    L2CAPConnection con = SDPServer.this.conNotifier.acceptAndOpen();
                    DataL2CAPReaderWriter rw = new DataL2CAPReaderWriter(con);
                    SDPServer sDPServer = SDPServer.this;
                    synchronized (sDPServer) {
                        SDPServer.this.connections.addElement(con);
                    }
                    Sender sender = new Sender(con, rw);
                    new Thread(sender).start();
                }
            }
            catch (IOException ioe) {
                SDPServer sDPServer = SDPServer.this;
                synchronized (sDPServer) {
                    SDPServer.this.acceptorStarted = false;
                    SDPServer.this.conNotifier = null;
                }
                return;
            }
        }
    }
}

