/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.io.j2me.btl2cap;

import com.sun.midp.io.j2me.btl2cap.BTL2CAPConnection;
import java.io.IOException;

final class BTL2CAPNetmonConnection
extends BTL2CAPConnection {
    private int id = -1;
    private boolean isNetmonClosed;

    BTL2CAPNetmonConnection(String url) {
        long groupid = System.currentTimeMillis();
        this.id = BTL2CAPNetmonConnection.connect0(url, 0, groupid);
    }

    public void close() throws IOException {
        this.disconnect();
        super.close();
    }

    public void send(byte[] data) throws IOException {
        try {
            super.send(data);
            BTL2CAPNetmonConnection.write0(this.id, data, 0, data.length);
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    public int receive(byte[] data) throws IOException {
        try {
            int len = super.receive(data);
            if (len != -1) {
                BTL2CAPNetmonConnection.read0(this.id, data, 0, len);
            }
            return len;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        BTL2CAPNetmonConnection bTL2CAPNetmonConnection = this;
        synchronized (bTL2CAPNetmonConnection) {
            if (this.isNetmonClosed) {
                return;
            }
            this.isNetmonClosed = true;
        }
        BTL2CAPNetmonConnection.disconnect0(this.id);
    }

    private static native int connect0(String var0, int var1, long var2);

    private static native void disconnect0(int var0);

    private static native void read0(int var0, byte[] var1, int var2, int var3);

    private static native void write0(int var0, byte[] var1, int var2, int var3);
}

