/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.i18n.j2me;

import com.sun.cldc.i18n.StreamWriter;
import java.io.IOException;

public class UTF_8_Writer
extends StreamWriter {
    public void write(char[] cbuf, int off, int len) throws IOException {
        byte[] outputByte = new byte[3];
        for (int count = 0; count < len; ++count) {
            int outputSize;
            char inputChar = cbuf[off + count];
            if (inputChar < '\u0080') {
                outputByte[0] = (byte)inputChar;
                outputSize = 1;
            } else if (inputChar < '\u0800') {
                outputByte[0] = (byte)(0xC0 | inputChar >> 6 & 0x1F);
                outputByte[1] = (byte)(0x80 | inputChar & 0x3F);
                outputSize = 2;
            } else {
                outputByte[0] = (byte)(0xE0 | inputChar >> 12 & 0xF);
                outputByte[1] = (byte)(0x80 | inputChar >> 6 & 0x3F);
                outputByte[2] = (byte)(0x80 | inputChar & 0x3F);
                outputSize = 3;
            }
            this.out.write(outputByte, 0, outputSize);
        }
    }

    public int sizeOf(char[] array, int offset, int length) {
        int outputSize = 0;
        while (offset < length) {
            char inputChar = array[offset];
            outputSize = inputChar < '\u0080' ? ++outputSize : (inputChar < '\u0800' ? (outputSize += 2) : (outputSize += 3));
            ++offset;
        }
        return outputSize;
    }
}

