#ifndef UCCI_H
#define UCCI_H

/* ļucci.h
 * ݣElephantEyeԴ1֡UCCIָģ
 * ʶԼ
 * c_
 * e_ѡ
 * g_ŷԤ飻
 * p_(ChessPosition)ĳԱ
 * s_̬(ȫ)
 */

const int c_MaxDepth = 32; // UCCI˼ļ

// UCCIָйؼйصѡ
enum OptionEnum {
  e_OptionNone, e_OptionBatch, e_OptionDebug, e_OptionBookFiles, e_OptionEgtbPaths, e_OptionHashSize, e_OptionThreads, e_OptionDrawMoves,
  e_OptionRepetition, e_OptionPruning, e_OptionKnowledge, e_OptionSelectivity, e_OptionStyle, e_OptionLoadBook
}; // "setoption"ָѡ
enum CheckEnum {
  e_CheckFalse, e_CheckTrue
}; // ѡΪ"check"趨ֵֻй(offfalse)(ontrue)
enum RepetitionEnum {
  e_RepetitionAlwaysDraw, e_RepetitionCheckBan, e_RepetitionAsianRule, e_RepetitionChineseRule
};
enum ScaleEnum {
  e_ScaleNone, e_ScaleSmall, e_ScaleMedium, e_ScaleLarge
};
enum StyleEnum {
  e_StyleSolid, e_StyleNormal, e_StyleRisky
}; // ѡstyle趨ֵ
enum TimeEnum {
  e_TimeDepth, e_TimeMove, e_TimeInc
}; // "go"ָָʱģʽֱǹ̶(൱Ϊ"c_MaxDepth")ʱ(ڱɼ)ͼʱ(ʣʱ٣ⲽӼ)
enum CommEnum {
  e_CommNone, e_CommPonderHit, e_CommStop, e_CommUcci, e_CommIsReady, e_CommSetOption, e_CommPosition, e_CommBanMoves, e_CommGo, e_CommGoPonder, e_CommQuit
}; // UCCIָ

// UCCIָԽͳĽṹ
union CommDetail {

  /* ɵõϢUCCIָֻ4
   *
   * 1. "setoption"ָݵϢʺ"e_CommSetOption"ָ
   *    "setoption"ָ趨ѡܵϢСѡ͡͡ѡֵ
   *    磬setoption batch onѡ;"e_OptionDebugֵ(Value.Spin)"e_CheckTrue"
   */
  struct {
    OptionEnum Type;             // ѡ
    union {                      // ѡֵ
      int Spin;                  // "spin"͵ѡֵ
      CheckEnum Check;           // "check"͵ѡֵ
      RepetitionEnum Repetition;
      ScaleEnum Scale;
      StyleEnum Style;           // "combo"͵ѡֵ
      const char *String;        // "string"͵ѡֵ
    } Value;                     // "button"ûֵ
  } Option;

  /* 2. "position"ָݵϢʺ"e_CommPosition"ָ
   *    "position"ָþ棬ʼͬŷɵľ
   *    磬position startpos moves h2e2 h9g8FEN"startpos"FENŷ(MoveNum)2
   */
  struct {
    const char *FenStr; // FEN("startpos")ҲɽתFEN
    int MoveNum;        // ŷ
    long *CoordList;    // ŷָ"IdleLine()"еһ̬飬԰"CoordList"
  } Position;

  /* 3. "banmoves"ָݵϢʺ"e_CommBanMoves"ָ
   *    "banmoves"ָýֹŷݽṹʱ"position"ָĺŷûFEN
   */
  struct {
    int MoveNum;
    long *CoordList;
  } BanMoves;

  /* 4. "go"ָݵϢʺ"e_CommGo""e_CommGoPonder"ָ
   *    "go"ָ˼()ͬʱ趨˼ģʽ̶ȡʱƻǼʱ
   */
  struct {
    TimeEnum Mode;   // ˼ģʽ
    union {          
      int Depth;     // ǹ̶ȣʾ()
      int Time;      // ޶ʱ䣬ʾʱ()
    } DepthTime;
    union {
      int MovesToGo; // Ǽʱƣ޶ʱҪ߶ٲ
      int Increment; // ʱƣʾò޶ʱӶ
    } TimeMode;
  } Search;
};

// ɱUCCIָǳЭ
char *ReadInput(void);                             // ȡһ
int ReadDigit(const char *&LineStr, int MaxValue); // ȡĳַе

// UCCIָڲͬ
CommEnum BootLine(void);                                      // UCCIĵһָֻ"ucci"
CommEnum IdleLine(CommDetail &Command, int /* bool */ Debug); // ʱָ
CommEnum BusyLine(int /* bool */ Debug);                      // ˼ʱָֻ"stop""ponderhit"

int /* bool */ QhInputLine(int /* bool */ Busy); // ǳЭĽչ

#endif
