#include ".\random.h"

__forceinline unsigned long long_mul_mod(unsigned long multiplier, unsigned long multiplicand, unsigned long divisor) {
  unsigned long result;
  __asm {
    mov eax, multiplier;
    mul multiplicand;
    div divisor;
    mov result, edx;
  }
  return result;
}

inline unsigned long long_rand(unsigned long &seed, unsigned long multiplier = 16807) {
  seed = long_mul_mod(seed, multiplier, 0x7fffffff);
  return seed;
}

unsigned long g_ZobristKeyPlayer;
unsigned long g_ZobristKeyTable[10][256];
uint64 g_ZobristLockPlayer;
uint64 g_ZobristLockTable[10][256];

void zobrist_gen(void) {
  int i, j;
  unsigned long rand_seed;
  rand_seed = 1;
  g_ZobristKeyPlayer = long_rand(rand_seed);
  for (i = 0; i < 10; i ++) {
    for (j = 0; j < 256; j ++) {
      g_ZobristKeyTable[i][j] = long_rand(rand_seed);
    }
  }
  ((unsigned long *) &g_ZobristLockPlayer)[0] = long_rand(rand_seed);
  ((unsigned long *) &g_ZobristLockPlayer)[1] = long_rand(rand_seed);
  for (i = 0; i < 10; i ++) {
    for (j = 0; j < 256; j ++) {
      ((unsigned long *) &g_ZobristLockTable[i][j])[0] = long_rand(rand_seed);
      ((unsigned long *) &g_ZobristLockTable[i][j])[1] = long_rand(rand_seed);
    }
  }
}
/*
// ZobristֵZobristֵZobristУ
unsigned long g_ZobristKeyPlayer=0x41a7;
unsigned long g_ZobristKeyTable[10][256]=
{
	{0x10d63af1,0x60b7acd9,0x3ab50c2a,0x4431b782,0x1c06dac8,0x6058ed8,0x56e509fe,0x56f32f43,0x77a4044d,0x31169898,0x427c3c55,0x6a5d128c,0x46cdbe2,0x6d7d4b3,0x43cd3747,0x55e83917,0xfc4111,0x3113c398,0x88e4954,0x35702e2f,0x57e82b11,0x4b63962d,0x77188b05,0x6c4f3258,0x437266f5,0xbc5816b,0x53b39dd6,0x353f7788,0x59c09d07,0x74856499,0x618fb492,0x21980f48,0x6135133,0x5e37ee62,0x2a039441,0x50fa4cf3,0x60d20f0d,0x7eda5023,0x2ec36ae5,0x1f9ef85f,0x7dc43530,0x5c8022d1,0x606df6c8,0x5364f5ed,0x94dc561,0x50d9680c,0x713e154b,0x22e82902,0x37dc5435,0x621c8039,0x3d265081,0x1e6f6484,0x233025b8,0x2dfc6514,0x15501ba2,0x3e46339c,0x72e666b4,0x7460ee5a,0x7c09267,0x73cbac2a,0x409434ca,0x4215dae5,0x28d61248,0x7e4a49e9,0x3f3aa0c5,0x221105f1,0xb9d22b0,0x795056c4,0x9709c15,0x40172b8a,0x312b91e5,0x23776a9b,0x74f7f84d,0x43cec339,0x3b72f5f6,0x787207f7,0x66926e8,0x61794ca1,0x62961005,0x69f5ead3,0x100bf8fe,0x207f3ed,0x581f4da5,0x6f22b8d5,0x5094e0f3,0x5e3c9ad9,0x5cda4ce4,0x7fee3c5b,0x71bcbbfa,0x1dd9546c,0x27358dc3,0x2cee1151,0x41b2f3e2,0x4ba99c20,0x6c491fae,0x34bf100c,0x6bb69ee1,0x2278fd06,0x352ba698,0x44c6606d,0x3be4b761,0x24c35fff,0x16d37134,0x13ad18a1,0x492bfc1e,0x66b53b19,0x43b1afd,0x4468da36,0x3fce3250,0x7a4942e9,0x5fc80db7,0x46fc9a81,0x7203af8f,0x4ffb0fc3,0x6bc7f43a,0x1473431e,0x1b3b710f,0x5b7b9dc0,0x10b1d72c,0xba59244,0x2325b455,0x624a7a,0x35078fc8,0x370aeab,0x5adb5e50,0x780d04c9,0x1eb565b2,0x172798de,0x28a522b2,0x7188e8f6,0x5376a8b5,0x133e2de2,0x57365a4c,0x3162604f,0x31a0fbdd,0x3ff7839f,0x12e25c88,0x4b28ee67,0x6c3bd2bd,0x4b88adce,0x7a4ad61f,0x472fcbf2,0x12f6a161,0x7ddcf100,0x3452778e,0x12272678,0x484e9997,0x2045ad97,0x3e87a50e,0x3b655a34,0x7b052a62,0x1021c707,0x1991a4d7,0x28dd2c5e,0x508be447,0x10381aa1,0x535c4858,0x4f91b429,0x66cb188e,0x1fb9475b,0x3cfbb7a2,0x31d50bf5,0x1a041b62,0x3a1cc46,0x736a0986,0x3697779c,0x122dbec4,0x79473f2e,0x34852336,0x10cac92a,0x715ced02,0xbcc5873,0x14c2ec12,0x9189c64,0x2ec36de6,0x20642f06,0x114b4387,0x643e5cef,0x3a478253,0x2cbd3509,0x39e4f8d1,0x678b7f08,0x77411b53,0x5369234f,0x1b8d4251,0x56fce1f8,0x74578d65,0x20041d8f,0x6e30a7b4,0x3c5252f0,0x40c32980,0x4cd9b3b7,0x68a5dacb,0x60bf7b19,0x3b2ad7ee,0x79c6689a,0x50fd94eb,0x383bf9d7,0x698faf18,0x583086cc,0x59e1e84f,0x7e5ac8a2,0x7a2a447c,0x6cf6678c,0x25085037,0x44ca5ddf,0x41d8fec1,0xd3d52ad,0x34fee2a5,0x49d1d9d1,0x70334e33,0x38532fd1,0x5d685f3a,0x6f4408be,0x5b9a2b03,0x667e00f0,0x5a6fc121,0x5ef08be9,0x2719eb1,0x716977b7,0x4332c98c,0x3b4e28cb,0x85845d8,0x5b516c2f,0x3e95b07f,0x557681f2,0x574d62b3,0x198b028c,0x7554426d,0x6ed53e48,0x71ec21d0,0x45a0191e,0x11d12448,0x39a4fc1b,0x7ea36e2d,0x1b968d4f,0x39174baf,0x2869eb71,0x41e05c71,0x70d52080,0x3848ed5f,0x3bd814d7,0x67404df2,0x2ebd7fd3,0x1b130d9e,0x7fe30df4,0x13a94fc4,0x50b3d6f1,0x4ee4919b,0x137f94,0x1ccd96,0x62fd32e8,0x5d19501d,0x28dacfab,0x3577f881,0x575bf893},
    {0x571ca7b3,0x1a460573,0x6b0fce7e,0x5abde91b,0x6a131a27,0xc1a2cd9,0xa7660c4,0x61cae939,0x5095cf57,0x1b5f8216,0x1b558064,0xa603341,0x31c4f5b9,0x79e05e35,0x79492815,0x31e6b8e8,0x2275a0f0,0x5898fe3c,0x245b4295,0x637056d8,0x6455b1e8,0x361329ce,0x241daf1e,0x18d3ed18,0x172cf64,0x188daefa,0x7ddaabad,0x1f3d2b68,0x68ecc8dd,0x11775afc,0x32f65f59,0x4cede632,0x16a40413,0x6a078701,0x14308909,0x7e74b839,0x20eae70b,0x1de6940f,0xd02741f,0x1c15a5e5,0x513e6bca,0x5916c471,0x65bb0468,0x591e7c05,0x606059f8,0x55b2da36,0x51143b2e,0x7397298,0x4c925cdc,0x1d0e96ca,0x28cdb6ad,0x59942cc8,0xf082c6a,0x619beadb,0x435801ed,0x46e69125,0x4b433880,0x2a32821a,0x59fb8e9a,0x124f4e9d,0x14b22ecf,0x3e1f22a6,0x6e1be026,0x68191743,0x47466519,0x5e9770dd,0x2872edaf,0x115290e8,0x43a7783a,0x27c64a89,0x4b477cc5,0x4250901f,0x3726053c,0x2121c26d,0x2f639319,0x324e669d,0x3932e738,0x3cea2ade,0x31a47410,0x23bfdfe6,0xa048760,0x2f53b4c3,0x2080867b,0x55fd05e8,0x568eee72,0x41c8aac3,0x5d4309f2,0x5c421eb3,0x78eda916,0x3af82160,0x785743de,0x2928e18b,0x3aef81c9,0x4231d159,0x54a74c02,0x336f42b9,0x4d859a10,0x7e45b832,0x13401b62,0x55c5c8cd,0x2c0236b9,0x4556c241,0x42eb5cf7,0x6a247e73,0x1e9e676,0x23194df5,0x524d21d3,0x45e7cddb,0x757c08b7,0x222062a3,0x7c2bccd5,0x1f94f3a3,0x6c076287,0x58d5c479,0x3a56117f,0x6896c6c4,0x2d3a381,0x14936b9a,0x5a7d5603,0x5a9a0d5e,0x37e3c4ca,0x4a8cc670,0x6038094c,0x7eea8ded,0x590c03b3,0x23c70a71,0x607e9310,0x15e930ee,0x8b647f,0x3f72ce20,0xa3ab76b,0x14dfd70c,0x739f5f88,0x64391505,0x5f932eaa,0x37dccbeb,0xcfcdf4,0x4ada4e96,0x425d803e,0x88e887c,0x45a28947,0x31e2b808,0x1ba02ece,0x3160e48d,0x503cfe4e,0x545bdc09,0x5acafe23,0x44f2da66,0x23e081e7,0x68707717,0x2f9abc92,0x57d22da8,0x27b39da3,0x1324cb2,0xd493abb,0x42aed1cd,0x63500bee,0x1c3f6932,0x713601b,0x90a903e,0x1483db15,0x5ca44a38,0x2604d20c,0x67a2554,0x3d28b11e,0x3a8447f0,0x428efb93,0x39269208,0x133d6888,0x2499c296,0x6ab6189f,0x590aa574,0x49f49057,0x573065af,0x2a63f0e1,0x75b5985,0x7e522e88,0x456d2382,0x364f6a,0x6d97b841,0x3c1eb9d,0x30539258,0x3eace831,0x49c0091c,0x5e963317,0x56f45b84,0x44a463b5,0x48e2348,0xfae4e4e,0x7c96eaec,0x18196bdb,0x2cf80339,0x4e9baa3f,0x4dc6366a,0x101e910a,0x46c42fca,0x7a1d9b11,0x2dafb7b9,0x6b46ea1d,0x7cb44cf0,0x21276086,0x20320e6b,0x3650a350,0x6811f50b,0x72eeda8d,0x1f4e99ee,0x615be850,0x58f10e1f,0x39d642d7,0x21be4eeb,0x552f379b,0xeebccce,0x1ad2f009,0xe8ceca1,0x4603457d,0xc73574,0x16865312,0x4cb7ce4b,0x3748c546,0xa8f9305,0x57fd32ad,0x300a28fc,0x6b08d107,0xfd35977,0x7c969bbe,0x3cb16d9,0xa490281,0x3f43686d,0x627cec8d,0x778e4f7e,0x20051684,0x2e094488,0x62725454,0x3ffe894a,0x5fe77a18,0x5600eed8,0x5740d304,0x60ddd85c,0x4a7b1b3,0x1d836128,0x1c5f983b,0x4803580a,0x53891d75,0x4eed172b,0x2f8c3088,0x1cc6491b,0x1de99a5f,0x5395e250,0x153d1d0f,0x5f3ecead,0x1472f0b5,0x6190590,0x54bc3410,0xffe31e6,0x797dfb3d,0x3df9a01b},
    {0x4f7e6c66,0x74fec54f,0x24c018b,0x4bf94dda,0x5c664a2d,0x3f8fffbf,0x6df7533,0x38876acb,0x4274526b,0x62cf10e2,0x85d981c,0x38ad5a8e,0x7d143db3,0x3bdef2ec,0x2a1e82a9,0x39143ad9,0x5f2399d5,0x1a489fbf,0x15efc214,0x2faeba4c,0x7848ec08,0x7b803ee9,0x20a27257,0x900be7e,0xfda46d0,0x435f09d1,0x147d9ae5,0x42443ae5,0xd76b260,0x6bb8c387,0x2f2d0b51,0x36420b09,0x29e297b3,0x5b557e40,0x49d3ca98,0x6f99e705,0x610e3280,0x6b15a347,0x5992c13d,0x31ccb9bc,0x77b5ff2e,0x4d846268,0x2e58c19a,0x450e7d3b,0x3a3fcfe8,0x336aa638,0x1ec6c0e7,0xaa28d7a,0x35f64a0a,0x3c76f233,0x25171148,0xd6fa0fe,0x1bb28a96,0x66a88c0e,0x43831fc9,0x559be7bf,0x6e8bd881,0x1f3335da,0x5b148b36,0x21bfb4f1,0x31004b86,0xa5e638c,0x3ad981a5,0x1dce95d2,0x65ce1d47,0x3ee45488,0x69ccfa,0x2210314c,0x5514860c,0x366ca977,0x17e9df8b,0x7b532af0,0x112831d1,0x65de9923,0x7917fd14,0x15e86a28,0x4d917354,0x82ab795,0x2c7a9b63,0x256f9765,0x413c7b16,0x69b502cf,0x6acb9a40,0x5cfc1686,0x2a2ae71b,0x66aab33d,0x50dd9e73,0x5cdb97f,0x54d43d3,0x139fd45d,0x622f2fbb,0x7e6d059,0x4278871c,0x76ee615b,0x1c39da5d,0x1a2f1e25,0xb641c91,0x598f796e,0x5a6d52b1,0x3f5010d8,0x2181f561,0x5b14c476,0x306e4db1,0x19aeb84e,0x1dc6160e,0x37d20067,0x3c1886d2,0x6e3b63d0,0x7d162539,0x38e60157,0x46213f0,0x430af3cf,0x40cbd6c,0x6067ff87,0x4bb92983,0x69547e4b,0x2a2fa3f3,0x1db4bc28,0x44acf554,0x371e8105,0x33a88b88,0x7e60a836,0x7bc3b20b,0x6cde2fa7,0x6f0ab4c7,0x27e2adc5,0x12fe74f8,0x7fb14f85,0x51dbe641,0x3be9df63,0x7748fb4f,0x586b3cb7,0x685f3fba,0x455101de,0x4951b95f,0x14613194,0x78fdf5ff,0x69217667,0x13e49a1d,0x541f01f,0x2bfb85eb,0xe151ddc,0xc5b5dbd,0x426729a1,0x2de2b16,0x47deb2d2,0x6dae1dda,0x422a0b77,0x5656d390,0x5e5bbf38,0x596725ed,0x2eb1876,0x1892ec79,0x55e30889,0x2c45866c,0x87c3329,0x1202cd19,0x75e72d8b,0x1c5f3d26,0x30a79857,0x4b0290b5,0x156a818c,0x35f1950,0x5876d4ea,0x61947c05,0x5b5a5e4f,0x9e5c364,0x4b7edf4f,0x7676e241,0x77005629,0x3718dac8,0x40c39cba,0x6a66988d,0x75a9878d,0x4d027654,0x5ca6ac4b,0x42799f72,0x3ed31776,0x14a96433,0x7cf15add,0x4984a340,0x22f9e475,0x4405cf43,0x596a5a98,0x5561df04,0xc78ab67,0x463cfd96,0x4e2ca6e0,0x557fe438,0x3f604462,0x49299e6f,0x4b60aeef,0x387cf392,0x135b1337,0x404a89ce,0x5d9d545b,0x40d5261,0x69b605b,0x42d2f9c0,0x290ace86,0x47cd477,0x1f60d2ee,0xdb8175a,0x31051cbf,0x46a258bd,0x4c700485,0x4e38def7,0x77b6523f,0x62d1e37f,0x41aed988,0x3e4b9168,0x533762cb,0x5937281b,0x342a325f,0x3e5115ba,0x3d69864c,0x5af00713,0x44609f09,0x23692af1,0x4d824660,0x23da7061,0x5a0802aa,0x43e71513,0x7818b538,0x1e21ad21,0x34ed60fb,0x4c7a19e2,0x64396ba7,0x75cad458,0x573b19d2,0x691c56bb,0x438244e6,0x1d797aaa,0x12643e04,0x7323820a,0x202e9994,0x5364d40d,0x9dcc41,0x77ccbfb7,0x233ec4d3,0x6dec0ab8,0x23b3ee69,0x79e941ce,0x40df79e9,0xfbcd145,0x354f1115,0x59ea950a,0x37def1a4,0xdca62a4,0x6212040e,0xcc8656f,0x387b60f7,0x2c1b1519,0x260632ee,0x60f9bac2,0x2b54484b},
    {0x2a564a26,0x71e1a81,0x495e0ecd,0x3e1dda5c,0x19eaede0,0xea71a6b,0x7cb76e50,0x6eab8627,0x3ef4a334,0x2f06cb36,0x67075e58,0x14c31840,0x146d1c66,0x7637704,0x131aab66,0x3beabf56,0x30b7c5d5,0x711d3bef,0x364a01ed,0x34c48a73,0x535d9f15,0x27774675,0x7b2bf91,0x683ecc89,0x72e66bd6,0x75b1e988,0x735b1c15,0x6290e1dd,0x15dca6b9,0x4945c6e5,0x40509f8,0x66d17ad7,0x42d7edfd,0x6e499f53,0x237b3ab6,0x6f4b94ec,0x4b1e4b09,0x31d06266,0x67ec3016,0x434929a7,0x784db573,0x35c3ceb9,0x4a38ef42,0x5fe3fc1f,0x70bd8867,0x2b465c04,0x184320ce,0x5f1ec0d3,0x5c058d6e,0x70885ff4,0x953c5e4,0x5ae50084,0x708508ba,0x2e00250c,0xb804e6c,0x149c9a5a,0x35599548,0xc57c555,0x565c55c7,0x4803a81c,0x6811eb33,0x706896a5,0x627a644a,0x514e68c8,0x72c14c2b,0x706fd5e8,0x3e44ac03,0xe7918e5,0x305169cf,0x30f9add1,0x58028d75,0xf952977,0x9d54b9f,0x1257b8c4,0x3d235544,0x5ab302b7,0x1e776ae6,0x320b31aa,0x7ce9a990,0x507b6d01,0x573185ee,0x744ff8fa,0x2e6320be,0x6dfab1bc,0x65aae60c,0x36e551f9,0x968ce97,0x3fd32054,0x3def8b88,0x39b1ad7c,0x3ff4c57b,0x5ed12f0a,0x77676a27,0x266a63af,0x12b689dd,0xe1515c4,0xa47fe15,0x7c7a19f8,0x343f28a0,0x1e843b2c,0x7b48d55a,0x6aaf46f1,0x195aaeef,0x1092d9ea,0x19209a26,0x2b6841ad,0x49afdb1e,0x385ab45d,0x4af76292,0x376885b1,0x2f2143e2,0x30efc29a,0x4cd1258f,0x36f8f6af,0x130b775b,0x55c90121,0x7f694986,0x595a3dc3,0x338cfb09,0x6cb5264f,0x68e6444a,0x658d8c13,0x2fe7677b,0x13ad4cf,0x3d6962aa,0x51cca665,0x52c05ad7,0x528c03b2,0x6646c574,0x304d7721,0x2dc8304d,0x31db26b6,0x2aca904c,0x58c78386,0x128bfff3,0x2550b408,0x555b8c5b,0x6d5bd624,0x28480d93,0x1273428e,0x4d168218,0xb71d32,0x75ddbdfb,0x30e3e631,0x421db40a,0x2c171e6f,0x21cf2006,0x253f7b41,0x6ab4fb81,0xfec08e2,0x513b3598,0x63bb7d2,0x3aa13f30,0x303b8662,0x13f3a4ab,0x60bfe0c8,0x553e9c17,0x179d5ba,0x65bea717,0x47cc0b30,0x24f2a123,0x353113c8,0x2909cac0,0x41de184c,0x5c0d475c,0x6bc8183a,0x1daebf1e,0x3b8559cb,0x2fca3cf4,0x667cfaf,0x973ed72,0x19e9dc37,0x4878ac2b,0x6a6f6038,0x3616331f,0x6b7653f6,0x25827298,0x17316c65,0x2dc366c8,0x7790ebf0,0x4b7216e3,0x2f3cb7c7,0x3b45820b,0x505cbe93,0x78e3ce1c,0x33f0ce45,0x6762ea7,0x38f0d941,0x4c47579b,0x5fc8a83c,0x6e9d2c44,0x10c55d18,0xd62db42,0x5528d0eb,0x6aac1ffa,0x4a678ccc,0x544ccb3d,0x7db33d07,0x26bd70a,0x75f2d2c3,0x18eb3cb4,0x7bde5a33,0x42f409cd,0x23af9412,0x5c223c0b,0x4b94256e,0x6b257f85,0x6ad72bb7,0x5477322d,0x5d7f53ad,0x524eb2cf,0x2cbd5e40,0x4476d2b2,0x5502c73b,0x29661e17,0x6f418d3c,0x389f9734,0x757ff3f6,0x2369d7be,0x79d30d1b,0xf01a619,0x353fbb01,0x6b0e59f6,0x7b345c62,0x2a9d651f,0x4359ec14,0x449a3797,0x68b7bdb0,0x7706a385,0x54d9adcf,0x1f221c8e,0x7880be99,0x4c616c9d,0x1021de98,0x1f9cd56e,0x718038f8,0x191c5bff,0x14dbcf3a,0x6b01f388,0x4d1b9c9a,0x4fc66a02,0x6b59d238,0x55f89197,0x321e7c99,0x6f863a83,0x556ba7a8,0xecc3268,0x1516f,0x56894e69,0x507afbe1,0x3a2e9a0e,0x49842af9,0x4216724,0x2cfa6e9a,0x6d735787,0x2f779834},
    {0x54a99644,0x49c875c8,0x7acc350,0x5f4abd1f,0x23c66f19,0x38a7e4a8,0x1694eea7,0xbc02186,0x72d8ea70,0x7f0799f7,0x4c0d6848,0x43975fa,0x58707240,0x3e5cf51c,0x48e02140,0x72a71620,0x379dc9ae,0x5823db08,0x1a01176d,0x3da90271,0x22df6857,0x793b39a3,0x1f453a83,0x7a047e7e,0x3d0cc0c7,0x10446821,0x7b1056de,0x6db747f0,0x1bd415d6,0xe5a2e0,0x64282095,0x6734992,0x7ae3138c,0x52188b5b,0x49652d78,0x118c46ed,0x10847a9b,0x698d5e95,0x403cbe56,0x53f4210c,0x40a5c5e3,0x4362db3d,0xf27a45b,0x73975a22,0x559ea977,0x2387ef8b,0x317fa0e6,0x321c756d,0x6a6160ce,0x1f1aaaf2,0xfcd05d2,0x5d392618,0x52f42178,0x19c177d4,0x6ca20c81,0x2e320df,0xd8311f4,0x180fb11a,0x2e342e4d,0x63cbd8ed,0x5c0ee2ca,0x554b6afd,0x4a5d33ca,0x2cf338ea,0x141da1b4,0x25633abd,0x15a56178,0x1ca21862,0x55eed89d,0x33cf577e,0x71792bc4,0x4a288b0f,0x2bc1abd2,0x37f77e6f,0x598dc61d,0x6ac9c7d9,0x655fae54,0x6cae40ca,0x241fc584,0x21e06fa3,0x15c147b5,0x444ac73b,0x95e1584,0x7fd691e9,0x60059990,0xfa4ee30,0x15119956,0x3669e7e8,0x62f84c40,0x1b563083,0x378af67a,0x43be013,0x76f40190,0xd92d1f3,0x2215af7b,0x3db3c5b8,0x6579d2ad,0x20f68fe7,0x1b619799,0x2427cbda,0x30b867c1,0x1aa3c8e4,0x76d9fe65,0x61ccd5d8,0x4eeb8a11,0x49b58a91,0x2d9c5b65,0x74345b47,0x1954cdeb,0xe9b0c4b,0x6544176a,0x595d6416,0x2560e30,0x5fbd7282,0xea8e5e9,0x728e2b83,0x53cae036,0x2c462434,0x30f2e8a1,0x1b86bb22,0x2a67c34c,0x246c854,0x750a03f6,0x648a4781,0x325c99b8,0x5d7018dc,0x6a704370,0x705ba4a7,0x10970992,0x2bf558c0,0x7895bbcb,0x2e5c4a46,0x2d105171,0xa52e8d4,0x4933bb97,0x6360dc0c,0x6c0ecacc,0x3f244e80,0x689dd5e2,0x52451e16,0x37ba608c,0x2d18a3e9,0x2cb12d20,0x2409a6cc,0x75a5ad8f,0x5025c3a0,0x5f4e667b,0x142a461f,0x6361a790,0x204011e9,0x4e57e889,0x6d63a28d,0x28450f16,0x4de18201,0x101e3799,0x2fd42613,0x110fc1ed,0x2184b75b,0x1021c88e,0x19f5eae8,0x601132a8,0x914e4de,0x3abdaf7a,0x7b4b90b6,0x1e09dbf7,0x19484489,0x578b8b56,0xa68e801,0x6d579efd,0x13872c20,0xf61f2e4,0x67915e9f,0x78db4dd7,0x5d39c3e,0x7b6ad6f,0x6a34565d,0x12122a24,0x668caac0,0x1d1e57d9,0x3319767e,0x4cb26467,0x53ddcd87,0x6e08515,0x7e412939,0x67f99df0,0x34f02ce4,0x41347e3,0xdd48a2c,0x7cbb55cb,0x6efdc266,0x55e5ef77,0x6acc99af,0x1e7de6f0,0x5bc4a633,0x4b7b8d56,0x1c7c2fd1,0x1d2750f3,0x339079,0x3951f809,0x34733445,0x776cb8e9,0x2e00640,0x41ba5539,0x303132e5,0x6e04711a,0x659d9a63,0x4e030db3,0x2a788ac8,0x4fdf6640,0x53b21cb7,0x527b5d4e,0x212ad630,0x353fa53,0x7e5760d9,0x1a97875c,0x5237b6a7,0x47b8b81c,0x303f5b0d,0xf72cb3a,0x397c54c2,0x11a0aa0a,0x4afb7f90,0x4573ed65,0x3de6a582,0x717c198d,0xa71b230,0x2e6972ab,0xce7505b,0x264c8cfb,0x6bbbc661,0x74dd4188,0x69f983a8,0x7c32c0f2,0x68198f91,0x6620adfb,0x6b7e6e1e,0x396faab4,0x52302ce1,0x58d291ee,0x686acdd0,0x3bee483e,0x18c8fd2f,0x3366255f,0x771f9a55,0x3bcd7f8c,0x3070df00,0x424091d8,0x1d271de3,0x731b3108,0x7e303f41,0x11890520,0x3aaf80de,0x58358ceb,0x23b6c58b,0x34633afe,0x5eb61490},
    {0x4002a84,0x26e74229,0x18a8a5b3,0x6816976a,0x232ee589,0x5bdf976a,0x344ddf45,0x647d45d6,0x5c741824,0x49dd12e7,0x51042193,0x66386372,0x905cc,0x505b9418,0x2c57dcdf,0x3c65cb37,0x3f00a6db,0x43ca942d,0x28c63920,0x6dd078c9,0x11aa0c72,0x3317196d,0x31865d4f,0x6c5806ef,0x72f6c7b,0x3a7b02ec,0x61fcf1f2,0x25707920,0x7b203713,0x7fffff8b,0x7fe24053,0x5eed4abc,0x2cc5ad54,0x65f67cc2,0x1978d8da,0x4ce4dd46,0x457b461a,0x20377899,0x19ce9555,0x49ae0caf,0x41c2daf3,0x5fb4a93f,0x4dd3982f,0x7eac5d93,0x66339edd,0x4702f396,0x12c62146,0xdb2844b,0x430b5ef3,0x1f86c5e8,0x492b1283,0x2acc7bfc,0x56dff357,0x8e10150,0x6c1d2fbd,0x702958be,0x2a815b79,0x129c7abc,0x5f3dd62f,0x54b8d882,0x338e6a42,0x4ae22d7f,0x47191341,0x3f3f34de,0x4ea7fb42,0x7660d265,0x4e95219a,0x20d12dc4,0x513afb1,0x4f739011,0x2bf774d7,0x317e5ce,0x15f038f8,0x4e2c2d08,0x36409050,0x48c29003,0x5d7cda46,0x2fde599d,0x2ecd6af8,0x3029d7c9,0xb15e5d3,0x4aa38554,0x35867414,0xe2ee880,0x29a232c6,0x57b37a84,0x48309d17,0x6f997607,0x4413fece,0x7cbda94c,0x7b5fc8f,0x3cd8143d,0xe18d000,0x7effb73a,0x465681f9,0x596f2682,0x10494ead,0x3ccc4835,0x798aec2,0x38f94673,0x7580453d,0x3841e40f,0x6de3b1a3,0x7fa37cb1,0x464f89ee,0xfe88c52,0x6c5463a6,0x185a5eda,0x550946b3,0x5400bd62,0x7c919803,0x3a932cd9,0x1465789a,0x11d0d0ec,0x24443f17,0x7c8a119a,0x4c89d556,0x6d15285b,0x80ca650,0x767ad250,0x7985bef4,0x3bbbc380,0x24202723,0x3ae97d5c,0x3725413b,0x6edda4c5,0x196cba60,0x314001aa,0x612d5928,0x683882ef,0x561c4e5d,0x5c5ce7d5,0x57788052,0x2830b45b,0x1590d6fa,0x5811c225,0x75e1384e,0x1537c558,0x7d1f4a,0x16913386,0x16cdadfd,0x1959c8bd,0x5589fd4b,0x565472cc,0x423cdb5b,0x29655556,0x3bc59655,0x2910c51b,0xbfc84ad,0x6f6a8000,0x38f9b925,0x12ea495c,0x537640b7,0x7892d92f,0x70f0da80,0x5499436d,0x1a19d47f,0x15cdeb3c,0x20ebb53,0x152c4733,0xdf67021,0x2e3b8db0,0x47d33586,0x7b5f1540,0x1f6c5c07,0x30ddfaf,0x3d85bba,0x716e124e,0x7173f90f,0x74e481f9,0x46113e63,0x1616f985,0x3e579617,0x683edffa,0x77e2cb8d,0x4aa1d378,0x4642918f,0x3c626752,0x606d5776,0x2a89356f,0x1613203a,0x41a8cb28,0x30b1d0c5,0x6a014e7c,0x7bc7e542,0x9c8f8b,0x2693eefd,0x3a2f37d4,0x71fa5d23,0x6bf8df4a,0x200baaa7,0x5df0ca60,0x6b7694ce,0x36239780,0x5aaf7044,0x33f3aedf,0x435dcd1e,0x43458f1f,0xbb75eba,0x33ac0b58,0x641cd8e8,0x21e49ab1,0x2767ebd9,0x17ad07c5,0x60d922a7,0x4f72339d,0x529ab12a,0x29e566c4,0x13bde359,0x1798f22f,0x3a43f7c3,0x443f4117,0x14ca7002,0x767f9df7,0x345bffe8,0x3fdf333,0x15699b51,0x4853edd2,0x7e229b16,0x11f4020c,0x2ab26b09,0x279131c5,0x2d5a90ce,0x14d8dba5,0x293c3854,0x309627f2,0x521899c9,0x4d18853a,0x4d2ca61,0x2ae4a8c0,0xa02eb40,0x45a2bbe2,0x3edd1625,0x24d8f761,0x2059142d,0x383ba6f2,0x544d76b5,0x29ac9050,0x368990,0x7c814d0b,0xce94d09,0x28c0907e,0x7a4e5518,0x2cb4d963,0x152c0983,0x7e248250,0xee792e3,0x55c7cba,0x7b009a15,0x648417c9,0x1c35c0ad,0xcfcac53,0x209583ce,0x38005a18,0x1f1afa61,0x242c063b},
    {0x464d1e0a,0x70ef4694,0x6d02d878,0x55d1e631,0x475fc6fb,0x6100ad58,0x73749e28,0x6d3b8f4f,0x613dc38f,0x1df21329,0x7fc7f81a,0x2171b480,0x300150a7,0x26561c90,0x5f6d4599,0x7ef470c0,0x62168e5d,0x36dcadfa,0x52221439,0x3b5dd44f,0xd1dacfc,0x1747db1e,0x6e829a82,0x406e057c,0x772a30ef,0x72f2d807,0x2544ee86,0x5087b287,0x7cd9e65e,0x45a3655b,0x6a535d14,0x7040295,0x184587cc,0x7cd66e86,0x61f25f71,0x6f5825f3,0x423ada1,0x425c2726,0x300e51d3,0x7c1e0c4a,0x18b90def,0x1d41d297,0x4c68c682,0x72c0a7fe,0x46554f8d,0xad9d60e,0x637436b2,0x62b31320,0x5aaccc7f,0x6a5d45b,0x7118a5c5,0x92b6285,0x7f510e76,0x228ca647,0x3ff89109,0x57fa06ae,0x5fccb6a1,0x78ea3529,0x584854c3,0x74b4fb7c,0x15eac5c0,0x685ccb7d,0x2433b112,0x3dae274f,0x7496d32b,0x5a01e7d9,0x331c85b9,0x158f4ee6,0x7384e918,0x1ae361e8,0x4630d422,0x2fb7282e,0x21aefc7b,0x67420083,0x1e2fcd6b,0x54573b48,0x2af51f3a,0x42d52ede,0x39f81319,0x4dadec0a,0x5563ac5d,0x2c93977,0x68dbb50e,0x304bdfea,0x4559946b,0x7c1f205e,0x5f863afb,0x658a65bb,0x611d0c11,0x3a0361e6,0x341060cb,0x1f42ca21,0x59e44c8f,0x1b5e6e64,0x54a17545,0x341a306b,0x2360db86,0x2bec4c8f,0x269656d0,0x581d857a,0x7a2639c7,0x639b7677,0x737eb1b7,0x2c5a09e,0x7cb3e67d,0x6e15881,0x347980ae,0x14ef3a6c,0x65e49330,0x17b6893,0x4d0e8ba7,0x75f2a876,0xe121779,0x45c31026,0x9595292,0x473bf409,0x31129f68,0x3d9f7e03,0x320a1690,0x344f619a,0x4790e04a,0x78753efa,0x5979ccde,0x4b7930b6,0x16d2370,0x24318ecb,0x3195c3fd,0x5f763079,0x486888e5,0x46f39786,0x226102ce,0xeff3404,0x14affa4d,0x2d59dfd7,0x6776b383,0x22039286,0x1888acdc,0x350cac19,0x52f6b884,0x43cc0ca9,0x9534e05,0x3c272f0b,0x30819a07,0xca75a72,0x3f22f8db,0x1100123f,0x1badeed1,0x3819e989,0x2d333e25,0x7f350651,0x7231f115,0x2ccad445,0x383614fc,0x669bc938,0x7db7b028,0x268e5293,0x49cf44ab,0x46a55c68,0x1255d414,0x40d67673,0x3ffa9946,0x5d64e37a,0xa928e7d,0x1bc8b5f7,0x16227961,0x314edaa1,0x2ff39951,0x21d6ad6f,0x151463c4,0x6da1e3ab,0x1f6a27c8,0x7259cb94,0x65449c32,0x7b6aca8e,0x20186fef,0x245cc45f,0x46604b9f,0x5c04d7d1,0x41f50989,0x3e452333,0x2d0a0935,0x6de28dac,0x34c34f90,0x29c9200,0x75353f56,0x7ad16337,0x48c8eedf,0x7fba97cd,0x3344553e,0x4b3873bd,0x6736a3df,0x3440ba69,0x58e5e4c,0x45d0d26d,0x10a715ea,0x498fbe30,0x7c0f670a,0x57360127,0x1a85d42c,0x482ca24e,0x6a53d3e6,0x257cd793,0x272d071f,0x7d2e9850,0x7e11ec64,0x4ab6d9e5,0x2a9b6fb5,0x42c2e9ed,0xa8be8d9,0x676403f7,0x57408228,0x4c213cd8,0x1a21aff4,0x19a6c993,0x14fbdf0d,0x23f0d93e,0x194687e1,0x6582d1bd,0x6f98035b,0x65048499,0xb9d8c9f,0x147b20ae,0x1f9e8a03,0x6176db2c,0x422f57b1,0x32264769,0x6f1a5837,0x2a95bbdd,0x4c60c002,0x63ddea7a,0x7e4d22ce,0x7a284329,0x69517766,0x6375ff8e,0x57dcf6a5,0x6bc4f7b3,0x5062400b,0x625abb67,0x32c599a3,0x4ae9b65f,0x35c43d65,0x669acd76,0x3d27329a,0x586b3bd3,0x6824c6fe,0x4684831c,0x25bbc76f,0x4b225bc3,0x3cb685be,0x73069c15,0x36f161b2,0x2145094c,0x3b656da4,0x14873,0x543b7605,0xbc16d77},
    {0x47f9a5a8,0x56eadd82,0x5574ae62,0x5f64cfc2,0x5383fa7b,0x7db1cc12,0x23ccf236,0x6431c996,0xa9ca3e,0xb1cacc9,0x793c5d2,0x76a061e0,0x1b79f5f8,0x64037adf,0x2077f9c5,0x24af052a,0x5e7c1b36,0x25dea6b0,0x3c91803c,0x747a0234,0x7626dfa9,0x72260cd8,0x20157374,0x604ed520,0x578a5945,0x3beaede9,0x3ca97aba,0x1ab86873,0x40d163b9,0x72ea27ed,0x6ae3738b,0x7ab6e17f,0x7c8e97c9,0x758f4d01,0x1308b8f3,0x21a66348,0x32c01d3a,0x62bee4dd,0x62a39bd0,0x634aa747,0x3a2c593e,0x35971348,0x5172f774,0x52d40a72,0x5ef9ecd9,0x6a2ccb45,0x22d55578,0x63de4b25,0x17179d5c,0xf5c0edc,0x64d39564,0x7ef50bf2,0x9e37dfc,0x36643076,0x6ba9aedf,0x5117e9b1,0x78ef8d0e,0x3715d029,0x79154fff,0x66372c73,0x30476672,0x1f96df21,0x6a12ffba,0x55342be,0x1d42caad,0xc0832dd,0x6e435156,0x5911da8,0x7a320372,0x6980700a,0x6f3bd6a2,0x41885ebb,0x60036899,0x7fc8460d,0x356f4105,0x1b15caab,0x33acae71,0xdf09738,0x2e57e4ae,0xc667347,0x1a1a40ad,0x318c2b3e,0x696b0cdb,0x731933ee,0x7ba0894a,0x689598ae,0x355afd26,0x68a1e527,0x5ccb991b,0x3ab0eb35,0x352202ad,0x4bddc71b,0x4d3ae486,0x55714106,0x7e641cbc,0x5e9abb77,0x89b227,0x500f1eb7,0x10a9a971,0x72b34242,0x56c335e2,0x2a06b4ee,0x1e508ad0,0x39c96d3c,0x57229bc7,0x21215282,0x12afe5cc,0x5a17bda9,0x4ca4d074,0x587196fb,0x96f661a,0x709839cc,0x19fab9d4,0x1bbe1a9f,0x5dc5caf3,0x648f479d,0x7aa6c7fe,0x5b94339a,0x5ec7f26e,0x18fd445f,0x1b93c5ca,0x29e5eeb,0x6b6997a4,0x6162c713,0x1bfbe258,0x35c90dc2,0x22a65724,0x56a30e41,0x6afcf9d6,0x676877a,0x4fb85de6,0x511ccfed,0x3a96fa35,0xe04cba0,0x5cd47c90,0x23e018d,0x34d7d121,0x44e2e8a1,0xd16c55c,0x51f721ba,0x37c76460,0x38ef73c,0x1f0985f7,0x2a3a2b0c,0x50e0367c,0x3019305f,0x45b6c5a4,0x6269b5bd,0xa1abdc5,0x61a0d5b1,0x62d898a,0x17a0c631,0x3c33c715,0x6b535293,0x2b5267f1,0x2f26156f,0x6d494297,0x64b2ff8e,0x23a7f748,0x685baa41,0x5a06c6ed,0x72ee1fc7,0x6f687cc3,0x34d71f59,0x174b2729,0x46f800b1,0x43f588dd,0x2cec8806,0x5cd658f4,0x7c6a2ac9,0x1e1f31ef,0x1207515c,0x1e6e7843,0x66998650,0x694122cf,0x33547a05,0x6f16f896,0x4d1a78d4,0x4f2cdd8,0x60a82271,0x3e6d5a4a,0x7d42d04a,0x2d78ea85,0x5d6cd915,0x1520219e,0x707f16e7,0x27b8d164,0x56bb109b,0x133f5c99,0x24d84aae,0x740ef867,0x2d66db8,0x4bbd4c7c,0x78e887bc,0x6a2785a7,0x48b7cd63,0x1b0d43e1,0x3e376a7,0x4a82cfef,0x52217a20,0x13d8f500,0x8bcdd2e,0x275cfb7d,0x4982dfbb,0x2f2e93b1,0x1ae261aa,0x479edb0,0x60e3c01b,0x8595e4f,0x233e98d1,0x62a2d36a,0x2fe606bd,0x26c47adc,0x2d5e1566,0x7bcef2ce,0x4fa6f1e2,0x59525548,0x2c5d17c8,0x13c46239,0x420c9652,0x4861035e,0x59243571,0x5830bb6f,0x6761a1a4,0x3abb4b02,0x5e398e6d,0x14b5c66f,0x29f6ac08,0x19856be,0x3866d4c3,0x671a6b22,0x776fba0f,0x48206c0b,0x48956b2b,0x49aef947,0x7e6fca1b,0x5d3df376,0xe3af7cd,0x4162bb07,0x38e4ea1a,0x3cc56e24,0x45c21ca7,0x4ae73bb8,0x1301d373,0x5ce12cc4,0x4342277f,0x2c2f2558,0x4b3ccb11,0x437efae,0x74588aab,0x60f81c39,0x410513eb,0x345ecaa6,0x3b4a7326,0x14cde233,0x58bd8cf0},
    {0x4700e14,0x58ac4552,0x15fb37f9,0x2017c7b5,0x79384c88,0x5f28b2e4,0x68f8c78a,0x24f46add,0x2a93e61f,0x53e9130f,0x6ae268d2,0x364fe9d0,0x387f728b,0x373920a7,0x78ed044,0x310b243c,0x5277f84b,0x424e2e39,0x1abcc231,0x5e712cad,0x582c424b,0x41b47726,0x2efa817d,0x404b4da3,0xfd6294f,0x353209a8,0x68180fe0,0x3ba7084,0x4530ec05,0xed75fc0,0x5dcf3ddc,0x50e666a1,0x465bfd85,0x41614ad9,0x5a790e17,0x418c3668,0x5c480776,0x7ce2034e,0x5a4735ef,0x79260c36,0x30ebeb5d,0x50a93fc2,0x179902ed,0x3e8f21b5,0x26ee1229,0x57ea55b6,0x59a14cd1,0x6cba5b4f,0x3ec0d74d,0x6677206a,0x16f143b4,0x3993ea30,0x1df412d8,0x3013245,0x438b518d,0x6f97229f,0x2b622df5,0x3ab74613,0x5659a782,0x18047418,0x4c61dff9,0x2db77b9c,0x69145636,0x3628291f,0x6a3ce00,0x6c296567,0x11c084ab,0x7645ffa7,0x6d93699a,0x68fa35a9,0x2d92017,0x7cc9c776,0x234653fb,0x5e3395d4,0xcb1c19d,0x6a1e30ed,0x641e4e08,0x1952292,0x6610a00d,0x4d7be9d4,0x234850a,0x460a54a7,0x503bc3dd,0x3b80b52,0x27ef3666,0x49dc7705,0x290a0f25,0x53685b2f,0x683a9570,0x5e292185,0x5e57d30e,0x57e16c85,0x109bbcd6,0x608a8e1e,0x28788516,0x697c1c,0xd53127a,0x48e20e6b,0x7120b82e,0x1b1c0e08,0x4edd3d1f,0x1ed7e6ac,0x70693605,0xb59bbeb,0x3040471f,0x4bfd5cf8,0x66e2c4c1,0x31e38fac,0x52ed7eca,0x661f2a4e,0x8129b43,0x7d8f4fd8,0x4bc32e4e,0x7b1529bd,0x2a67766c,0x6e8fc233,0x2016dafa,0x3c82638b,0x145559b6,0x6f74c627,0x5b7d639b,0x516840a,0x936af22,0x6523e5e7,0x17cad491,0x54987cb,0x1e722323,0x5760de72,0x18ac3b2f,0x53619750,0x2c152ff4,0x22ff52c8,0x2893da6b,0x2e8bb9d,0x7d7541e8,0x1d3a26b1,0x54c23d74,0x1c50b625,0x76e645a8,0x7e75594,0x64a36b99,0x24ed3d6d,0x535bd20b,0x313afaee,0x17303882,0x5ecdeab2,0x20eb7cbe,0x444aaed4,0x31c0353,0x241e3fbd,0x3deaa3d1,0x77a90e18,0x7bdc8707,0x4b251c18,0x71579232,0x2c3f4ac0,0x6f4499f1,0xd6d649,0x188e530d,0x27ee8713,0x1ce604e0,0x414a1cf2,0x68b2755a,0x1c369d69,0x459866f7,0x189005d3,0x176e6c3e,0x52846676,0x7262f74c,0x3f59d93f,0x23c5d797,0x11cd0cda,0x2d06c557,0x1785e9d9,0x58bbb19f,0xa8a6b3c,0x586358c,0x2e257d29,0x1f3c266a,0x25fe092b,0x490bf989,0x312bb6d6,0x2cf0b4d2,0x6eef5e0a,0x25071b6c,0x75996271,0x290e2508,0x5fa14546,0x54cb27b6,0x659c4937,0x778aedfe,0x420efc02,0x65c3092f,0x679020da,0x275cfd54,0x49fba9fc,0x29550556,0xcd1664d,0x7934fce,0x585c6144,0x18f5e4ae,0x3778684f,0x420836fc,0x2951fc42,0x4588663f,0x7df0d5c2,0x4e61f426,0xe412fe,0x7d9ae226,0x43756d36,0x525516d3,0x504da0df,0x187cb9a9,0x248112ce,0x15f9a51b,0x38c69ae2,0x76e2888c,0x1272dc4e,0x32dd8e58,0x6fac4d7e,0x1913c479,0x60c7f0cb,0x6691d110,0x6f34a60b,0x69815536,0x2a018257,0x4914334c,0x4d33e80f,0xac85862,0x67228f75,0xdf87f39,0x35687e59,0x5f3f2073,0x296b8edf,0x5470e7b7,0x407ccab0,0x40df09e3,0x7302375a,0x168030b3,0x39fd434f,0x224e1547,0x3456f9e9,0x3a314ad7,0x7a288719,0x7abdb8f6,0x3dba5d6e,0x164c006b,0x57af7c3c,0x4205741d,0x740a3dc7,0x4c5e0f55,0x3340bc9e,0x5f1f435b,0x7d7f3c26,0x2c462328,0x30ae2dcd},
    {0x7b4106b2,0x6a1ecf55,0xcbe0be1,0x10fde750,0xd5d3de7,0x648b0f8b,0x65a9a23e,0x63dac896,0x30a72311,0x2cef4a0b,0x11e62f39,0x1f26505d,0xc6619a5,0x31da5ff,0xf7d09f2,0x5a17f6cf,0x5b4cbe3e,0xb5e0746,0x4a2f8a7e,0x772d7c3e,0x4b380792,0x4b7928d2,0x7f6719b3,0x49c8781d,0x845ddc3,0x22e23173,0x301c86e9,0x20dd43ac,0x1e85e20f,0x67bc5670,0x7dcf0844,0x2327e8e3,0x112aa11d,0x5b77fb9,0x52224d9d,0x4a15a88b,0x53ec63ac,0x4483dc3f,0x2cf0cf3d,0x75b5c4d7,0x708e3ba0,0x9ecbf1b,0x15f68ab4,0x6d0c3aaf,0x3de0ef17,0x7a70eebd,0xc49f918,0x4c809cf5,0xfc0c010,0x37816284,0xf6ae494,0x32c4b874,0x1129e1b6,0x54a17c87,0x35f6ae79,0x5638a59c,0x2100d0fd,0x3c98a2f8,0x48f366dc,0x63e61aee,0x17f2327f,0x1dd13c21,0x13c2a9d2,0x511b2420,0x4ce0da79,0x3e27655d,0xc6fdc8c,0x3f871b5,0x2bf1241c,0x6479c0cd,0x75610643,0x34e254e9,0x7734a81e,0x220986b6,0x1f6b282f,0x341b35c6,0x666774e3,0x122b179b,0x4b1aca6e,0x4be02247,0x67ea8a3b,0x57195cc9,0x421abccb,0x6960d554,0x5455b3d8,0x46925529,0x31151af1,0x609bdd63,0x18e3c022,0x105b04f2,0x47a1b441,0x49413c24,0x59d3850e,0x4dc48834,0x21ca35cf,0x6292ba5d,0xf09623a,0x310fd58c,0x68cf37e,0xfc5d88e,0x60c5ab9,0x15182ac9,0x65a0fcf0,0x2c3e24b0,0x23dab581,0x6bc23a8a,0x1c91714b,0x10a50194,0x410aa415,0x219a800f,0x264d6a05,0x246b81e8,0xe1db906,0x415e4027,0x12c5e1f8,0x7d766a68,0x69441231,0x740684f4,0x5802eaae,0x277d72a6,0x1cf2048b,0x55085085,0x14de7760,0x196f4a54,0x5978ddd7,0xe2c7c25,0xa8a6868,0x4cc8940,0x1046cb36,0x17c74e93,0x1df7a117,0x6c70fc5f,0x6dc8f897,0x2538b9d0,0x2f2f19c7,0x3d457004,0x19bd3609,0x55269612,0x5846a36a,0x592b16d,0x61be6df6,0x1d25639c,0x1aea5b7,0x7101923d,0x1e281cc1,0x5b77d25e,0x1794483c,0x812673c,0x70379847,0x51ee96df,0x6f3347f,0x48fb8169,0x77ed39ed,0x7776341d,0x71579930,0x2e0a5872,0x2934bbfb,0x452170df,0x167963ee,0x7b8fa9c8,0x14d3c8d8,0x5c26e796,0x7e2e581d,0x149b18a3,0x526e7fe6,0x548eff51,0x781c4a35,0x94c1b2e,0x638c6dc6,0x187b1539,0x38ae5dbd,0x3f8c405d,0x10d5ba43,0x3fb78d57,0x2ba06b6f,0x30ed5ac9,0x2ee35b37,0x50798fed,0x5cd839e1,0x77c01265,0x62f7e24e,0x2aa1a5,0x6eda57b8,0x40b529e3,0x35d11745,0x324ece9d,0x53debf38,0x44dc208c,0x4fdceaa5,0x30b11f99,0x3c918ec8,0x78350b88,0x62884b5f,0x620c7c82,0x21c26d18,0x638853f8,0xb40f1d5,0x54c4dcb8,0x4876df82,0x744bf4f8,0x26c0016e,0x79df0a2,0x12211f96,0x3ca0ba26,0x5c1d33e2,0x13969ad,0x6048dd7b,0x4fc4e79f,0x842a0a3,0x4e403191,0x58764eb9,0x3f2a810e,0x7f7ede87,0x6243b275,0x4a7951b9,0x62e46ee1,0x32ba880,0x27436d20,0x3bb16403,0x7b1d1f92,0x3503e963,0x13cf7dc6,0x1b4a5c53,0x2ef35b24,0x6ae4b090,0x4c03f4c3,0x17ba5532,0x4a2f51c9,0x68a2892b,0x6db9bb8,0x3bcc508c,0x62bc35ff,0x327d2afd,0x379161f0,0x29b4f010,0x25fcbfd4,0x74960ac7,0x269dca9d,0x41611d39,0x4ec5aab7,0x134afcc8,0x2019b85d,0x7896f221,0x7df29260,0x40681d39,0x7356aa37,0x3ec13c09,0x4c930f,0x234abdf0,0x7ffbe9a9,0x73a997e3,0x332f368,0x60a327c,0x7786dfd,0x737d00df,0x13c46bb5}
};

uint64 g_ZobristLockPlayer=0x447b4236;

uint64 g_ZobristLockTable[10][256]=
{
	{0x272f96b8,0x2eea1baa,0x7af0577f,0x546af1ed,0x4ab61a06,0x422ba9c1,0x2f9abd61,0x44ed469d,0x5ae1110,0xcdaf3d4,0x4a467509,0x52235619,0x68799b32,0x512e7ce3,0x157eae6a,0x5f360548,0x55c36399,0x5eaf63a4,0x773c5aac,0x7d36f11,0x2e72effb,0x1680e4d7,0x21dfeadd,0x4834db5e,0x3d894488,0x59887a6d,0x681cdb51,0x42acdb,0x9091d5e,0x3490,0x7c7a2279,0x4c4f77bb,0x284bbc02,0x66dd5a8e,0x1d224071,0x22234f1d,0x19e598f1,0x52a99fc7,0x4b1c0df7,0x36ee52c3,0x1b57d1a9,0x7a0b67b7,0x2d43c982,0x111862bf,0x1c3de4cb,0x11836230,0x575c0b2e,0x5c20a9d0,0x21374312,0x7fa2b803,0x192bdea5,0x13fb9819,0x7d6be62,0x4f3f64b0,0x2d0a38c0,0x2de795ac,0x12bea5f3,0x42ac7be0,0x6e76846e,0x7a0f491e,0x6e16d424,0x7420f944,0x79a28cc6,0x736f47c4,0x2f0c13b0,0x224a901,0x29eb7f58,0x4aa06ac9,0x770d0521,0x6faa2f4b,0x754fad76,0x6d6154ff,0x117005c7,0x1269b661,0x5058b354,0x6eeb69c9,0x4e33321a,0x43915657,0x2eff3ecb,0x4664ab55,0x25e6f328,0x49ee469f,0x17f406ec,0x62ba940c,0x4634a733,0x3510a45,0x61bbfb41,0x3e1554e2,0x6466af9e,0x3bdff9b,0x6dd6c23e,0x5d759646,0x2a8d724f,0x1eb168bc,0x67efbcd0,0xd03cc16,0x18ea5e90,0x1db6a4b1,0x1a1fb441,0x8751ac2,0x7d96efa7,0x43828259,0x2eac2d5c,0x23692ea1,0x39d3c98d,0x3f83f1a4,0x77686f6f,0x390ef503,0x229ab3bb,0x133ad216,0x6ee44c2a,0x77df59ce,0x7594c2c4,0x47b25b7,0x160adbf1,0x2469e7ad,0x45987aa6,0x409c94,0x40d6f0a,0x4eb2429e,0x13568156,0x4e2c6ba8,0x30edcce0,0x39f83c96,0x5d6f127f,0x12357298,0xdbc7929,0x7bf5e62b,0x10e3a172,0x106388d9,0x7242dd58,0x4dafe7ea,0x4f85a25,0x1dce9b9a,0x15691693,0x8be86c3,0x3e0d7efb,0x5774f34d,0x12177bb3,0x74253890,0x1d81ea58,0x1fd72ced,0x1c0d2d23,0x53940489,0x1ce3b17e,0xbb173c8,0x1030fd1,0x6e4f5150,0x587a35e1,0x20fb0e9d,0x793ce88c,0x24012a86,0x197bcbfe,0x7370b652,0x4e258395,0x69f61c6b,0x2831a8b,0x71f61284,0x522ed475,0x6ed5ead6,0xc0ecd7f,0x6e3e428b,0x42626e07,0x3e2c9379,0xb3e080,0x154b019e,0x46db5526,0x7cdbc6bd,0x58575bb3,0x5844a7b4,0x22b4f8d8,0x35dfe8fe,0x1dfe0b66,0x35f3cafd,0xd162ffc,0x3722f15a,0x3b103fb4,0x50f7a2c7,0x6101cafc,0x3617c446,0x48792313,0x3766c32b,0x4d310b31,0x3cd1f611,0x1d9e89cc,0x41e554f7,0x7d49e6e7,0x3677a393,0x55bc68ef,0x1935fa97,0x64220f54,0x18ed4f0c,0x129f8468,0x5d8e51b9,0x3e733865,0x61e3e585,0x39986fd,0x54149d62,0xe0baa1d,0x639cae88,0x38d56bab,0x13bae66c,0x4c07c608,0x6adf764a,0x4d15ed43,0x198b4be3,0x3e7208d5,0x599f5707,0x345c6e22,0x7346926a,0x16619b29,0x7642047b,0x478a432e,0x3e3eaecd,0x442b044c,0x4bf7bb64,0x14422db9,0x5bf922d8,0x3417d093,0x168d243,0x7829541,0x7d12209f,0x1ed253a9,0x2e48ec63,0x690d8bfa,0x2844eedf,0x2ab96995,0x52a4d620,0x2f4fc088,0x139c3738,0x5f704d3,0x4dce34f8,0x48ac0cab,0x3557cdac,0x510dd7fd,0x591f0aa4,0x1f7336a8,0x6a6b8e17,0x52ab883c,0x5d60a65c,0x2addd1fd,0x7b877a04,0x4bc67466,0x36e5142,0x46e2fb4e,0x252543f8,0x3fae005f,0x26ae33b6,0xf06ddb,0x606ca94c,0x36dd8fc7,0xb8f600,0x39f3ea50,0x38353115,0x5624afb7,0x46a7a43e},
    {0x3426dfb5,0x3f71c05d,0x25c190fd,0x6e88334d,0x2abfc282,0x6ee314fa,0xe195cb0,0x1dae62b,0x6f68e413,0xbf49710,0x746e6b5f,0x61014613,0x6cb7c971,0x7f6b2be3,0x2c5a6609,0x1d93a0c9,0x4651dbc1,0xb6f8766,0x1970a7ad,0x7701b4e1,0x3f53a614,0x2e6c5299,0x60b1a8d6,0x571c781d,0x38b70006,0x46c22db8,0x5c476d28,0x598c3235,0x6470abcb,0x6de5e833,0x6521d204,0x3b111b21,0x409b0341,0x41804b82,0x22c337a,0x378b432f,0x77eb440c,0x63b3e45b,0x3f45f2e1,0xa494442,0x78f695e4,0x5a9a0a56,0x412a1b82,0xa1dad3a,0x2effdb87,0x2fa2e4ef,0x1645c1e3,0xc48f3d1,0x7a3e8fda,0x31cd3b18,0x4e351308,0x194041a8,0x3a202a6b,0x2efb7a93,0x6193c3c8,0xc7c67bb,0x589477bf,0x1c36d0c9,0x16a429f5,0x67d56bc6,0x1f81c77f,0x48ae88fa,0x21e30dbe,0x392614cb,0x6c5f9b0,0x74f60401,0x50ba809b,0x7ce69cf9,0x2d3e0f1a,0x6c8795f3,0x7b05cf29,0x6ddbefda,0x6f138c80,0xd89de5,0x2d3d04dd,0x503cfd81,0x5f3dcb0b,0x20e5c3e7,0x3e1d8a3d,0x124a9cb2,0x3ef1c852,0x25d3bb73,0x7be74c19,0x492e96cd,0x5c04b76d,0x6337f8cc,0x5da47e69,0x349614c8,0x6819a602,0x431f2b73,0x4b2631b6,0x5e3e9502,0x22be4989,0x5ee4334c,0x3676da2d,0x6c19996b,0xe85cb7c,0x579faf8b,0x24d25d1f,0x1fe49c7b,0x54af223f,0x26f2363,0x3db8b58d,0x10013faa,0x33d06474,0x3db99e06,0x2aada227,0x6699eee,0x333c7975,0x4dfe2906,0x36d6489d,0x36a27e62,0xcb6eee2,0x3cee3c50,0x48d4a935,0xa6bc720,0x30b29f01,0x516bbedf,0x18ccf36c,0x7a2c12c,0x4bc4f230,0x715e4d9e,0x685a654f,0x65d13937,0x124be29c,0x1b97c87b,0x27c2c152,0x4deb7646,0x7c3a0c39,0x71679770,0x615fb0c7,0x1c4b7042,0x35586b51,0xd47b70f,0x3845ec04,0x640b0414,0x632c2fd2,0x6061a37,0x6873fc07,0x47e12a1a,0x9b2f949,0x2243d292,0x4a1c22ef,0x51f09687,0x753981de,0x618ef059,0x413f93ba,0x7a635ce7,0x63ca0d8e,0x7a1d3421,0x46f394a3,0x74930def,0x34b7c146,0x3a3a028c,0x5de0d1e9,0x65539faf,0x4f85042c,0x46689cf2,0x57997ec2,0x5fea1570,0x4c7758a4,0x69968036,0x1ac2771a,0x734f1bce,0x2724b9c3,0x29d12938,0x3b8e9fd1,0x12054f9b,0x68f9e20b,0x237538b9,0x6f844f8e,0x64f43f2e,0x1dfb650a,0x48dbfd26,0x75cd5dc2,0x7d3e0cf1,0x684827e8,0x6e9faf0c,0x74919e16,0x50a01b9a,0x6a51d43b,0x486c55d6,0x63da0ba9,0x4351a414,0x509aded4,0x81a1179,0x34b6ae68,0x555ccf66,0x2ddad36c,0x41379a10,0x5033c34f,0x79917741,0x3749a447,0x62b79f4,0x5b56d979,0x1131df5b,0x64e2e5e2,0x39e0d44b,0x1b0fd1ae,0x3a6915ec,0x66dc007f,0x14eae4cd,0x7f1635ee,0x31cc2b73,0x2bbbd2f8,0x1aae77ff,0x681b3408,0x37c76f74,0x244e7d40,0x2e8afcd9,0x41a677b1,0x2b6d7722,0x6b2d38e8,0x44802a7a,0x31464bfb,0xab1a702,0xe28c7b2,0x224b1e3b,0x47659cb3,0x732f44db,0x735220d7,0x1ea6e6eb,0x67eacb3f,0x6a6ae21c,0x3740ac52,0x5ebd5c4d,0x1c01923d,0x4b498f3a,0x6f162d27,0x57520996,0x394768c6,0x17034942,0x48e3d861,0x383126db,0x3b896313,0x367f6461,0x2aec9bf1,0x752ed2b7,0x1135cedc,0x12b11cda,0x79f6f98c,0x311da510,0x7623ecdf,0x5d70bc01,0x46d9b1f2,0x6edf23a5,0x18a764e7,0x6eca834a,0x1cd31aab,0x75837a86,0x4601d164,0x23f42c97,0x65ece282,0x2566e3ac,0x1c24c29f,0x7750f06d},
    {0x47ad8ee,0x4456fe9e,0x4ca6bf7b,0x3b4342ce,0x47742805,0x62feeacf,0x393d7fff,0x4896c23c,0x25a2c83d,0x78da9f0,0x447bb480,0x6b5c016a,0x46aa8839,0x2258be56,0x71133eef,0x6a0a0d1b,0x4cf32fb0,0x70fcf4a8,0x40dd1bad,0x239272db,0x62a395bf,0x1690c871,0x2d2429e2,0x5964b43d,0x7f63b37b,0x4d198093,0x11299299,0x318197c4,0x1bbd55f2,0x7ea8d4e1,0x11ea7904,0x68da2026,0x6e2fa0c0,0x74403335,0x29a2ce29,0xb967bb,0x16756851,0x4d3d1ed,0x55b8e0b6,0x595f5bfd,0x7edc6b41,0x26d39287,0x6e54f501,0xad62769,0x3bbbcbcd,0x7d30c0f0,0x3fb3a136,0x562611a3,0x336c79f8,0x78d4a2c0,0x971863c,0x13aef569,0x63aba218,0x44794db3,0x1e70778f,0x881f49d,0x401f5590,0x5b1692c,0x395faecc,0x16c1c249,0x4e70bf6d,0x42f24829,0x55838d82,0x44d33c63,0x5a59df99,0x710c9cd8,0x73d76017,0x2bfd7916,0x753b48e0,0x45fdf915,0x7f4922be,0x614aee18,0x2657c86e,0x6d0bc106,0x1b280ca4,0x783b836e,0x799251d8,0x13d7bf2f,0x5351cefb,0x39b0654e,0x5ccda491,0x224bcd9e,0x3c893df8,0x6a83ff8a,0x79879a96,0x4b0edd35,0x4b49bbf5,0xdb4ad15,0x57a938c8,0x5fe3a2a9,0x6e095c29,0x5e70626f,0x234fec2e,0x2cd8dab5,0x2e710f0,0x3e5f0fb4,0x29b8d611,0x2f344eff,0x4983af1f,0x683a6215,0x3472d5a2,0x20d3f45a,0x5472dcbf,0x8eac853,0x3cf7a9cf,0x6caec13b,0x2de904e9,0x344a60ae,0x4c414051,0x6fbdae7f,0x7f6c5f3,0x125794bf,0x6639f345,0x16cbfc53,0x4d94ff36,0xc6ef691,0x72ba691,0x71fc1d9a,0x5ac70bab,0xae98a05,0x60bd856e,0x795322a2,0x307dc1b2,0x35728d5c,0x36cdb168,0x5fb0236,0x39bab385,0xe35175f,0x628ef0a8,0x647d7099,0x42b7881a,0x521f9f0d,0x497913cd,0x8030b9,0x4e6ea4cc,0x745875be,0x6e15ac0d,0x3cbadeab,0x5d4d5d33,0x1da1ef8,0xce9b4dd,0x1d6e2955,0xaff31ea,0x69b4f3f,0x17b258ea,0x2dc4ac7d,0x2bbde320,0x15b90320,0x7d7cacd5,0x3c169259,0x1cb5537c,0x290c668b,0x6180474e,0x61f204b4,0x454163c4,0x321d6933,0x7ebf2468,0x1fccdc63,0x48babbe4,0x20859ad0,0x5100ff82,0x3d27b04a,0x16350a37,0x6924dff4,0x5a40b2c3,0x4a499ba5,0x1242710f,0x331ab2be,0x7a2e2f60,0x26889cc6,0x2cb60423,0x7f6d685c,0x4d4f093f,0x64553f33,0x5666a1a2,0x60064d15,0x1f94d328,0x7a894e68,0x12149fb1,0x41ef4665,0x794e6a47,0x4e34f715,0x5aee038,0x67fd23bb,0x5b66b09c,0x3e1d6ab5,0x2f581984,0x224a2d8c,0x6db1424b,0x160425c2,0x5d86dd6c,0x7eb64ee4,0x5ac2c9a5,0x7eed76fd,0x22b27482,0x21a18347,0x729125c3,0xd469eb8,0x2f00273d,0x6b35713a,0x5d8cd878,0x7b412694,0x5b0147d4,0x4dab1f9a,0x783505c9,0x230fccf2,0xd376c00,0x4961b83e,0x26378690,0x102934d0,0x34c20abf,0x13b5f1dc,0x3794439b,0x24c650d7,0x15932700,0x433437d4,0xcdd97ce,0x18e5d04e,0x6052b27,0x5a092e85,0x1634c3d5,0x63046070,0x5f9e6e67,0x2fd71bac,0x2dd8fa0b,0xd23bd7b,0xe1fb448,0x30bca1d3,0x1b094bad,0x2511d950,0x1ec9fa63,0x41adec5b,0x8fdca3c,0x4613c035,0x77a9b535,0x73dd1660,0x6db15e27,0x26563b88,0x6965cc4b,0x4dad70de,0x2fa53cd7,0x1c556234,0x5fd35306,0x6a5f5075,0x5bc13289,0xeb548b,0xb03094a,0x734551f8,0x4d4df1b0,0x26d86cf,0x3b028ff4,0x3fc1e227,0x77bfae7d,0x6539f718,0x8edb801,0x257d1b7d},
    {0x726d9489,0x5663156f,0x2c494b9c,0x465cce3e,0x152d91b5,0x6300518b,0x2cfdfe2b,0x148f119d,0x509f71a9,0x23bb2800,0x7ef3da5a,0x7af7e82b,0x421a1a98,0x685b5e7f,0x6d50d02e,0x2d1376c6,0x7ad8c8b,0x396d581c,0x44dc12a0,0x4a348a98,0x27afac6e,0x329ea116,0x26e12e5d,0x3558efb9,0x5ab3fe61,0x6c18c1ce,0x4fa32252,0x495f90e5,0x32e00941,0x7a089755,0x357b0a7e,0x65925043,0x1a4b067f,0x21b945e9,0x3e77345e,0x7ee10b18,0x451f5da6,0x5f9a613f,0x419b2097,0x1f4715ca,0x67d48322,0x30d97e81,0x19ac435f,0x773972ad,0x7d5ce024,0x3dcc96e9,0x46b1dcb7,0x53b8cbc8,0x13566043,0x70acf66b,0x7eec6c96,0x43423080,0x64258031,0xc7b14f7,0x1abcf8ac,0x1f897141,0x14884ea8,0x79478354,0x783f95e6,0x59e76df0,0x43a4500,0x5d0b50fd,0x37bbb410,0xb34e10d,0x7a1c2cef,0x668e57f2,0x7db70f04,0x309d5495,0x74396a43,0x7f6be9dd,0x4713fb60,0x1c5cdaef,0x348954aa,0x7f7c5069,0x6ca6571,0x1cdfc391,0x6ff84159,0x66a41d90,0x1312c1e7,0x3e3324d8,0x793d1e18,0x335d525d,0x30033d85,0x327bcf6c,0x3e78b4d7,0x4c8c9994,0x16f1cdd7,0x67041df6,0x62dadea6,0x3242058c,0x2f0d4f03,0x1220799e,0x7896af95,0x500db6ac,0x769ba28b,0xb2379fe,0x61d477ce,0x4f3bc02c,0xffdf5d3,0x4842bc51,0x2ab4eaa4,0x1c3023db,0x1e38911d,0x6658d4ed,0x55728b5f,0x61100eb4,0x1aaf14d5,0x71b6a20,0x1e897a7f,0x3f5b62c7,0x641889a5,0x37618ea7,0x740c03a6,0x742ac540,0x7fbbf6e7,0x3bcb0d66,0x66522db5,0x47b8f9e,0x2586f256,0x5fc54c25,0x5f84044e,0x5a0616aa,0x3ed14881,0x418bc753,0x37c09fed,0x2805a3d2,0xb3c7d08,0x4e6fe276,0x69983091,0x1a6053a4,0x56321509,0x2ec65d86,0xe197c05,0xa1fab4f,0x59ff1264,0x2eb97a54,0xab093fb,0x76fc23ed,0xb462cf1,0x26308d03,0x92f6a35,0x7d364aab,0x587162bd,0x58bcf88f,0x1d6c887d,0x36759fbd,0x4a140c9f,0x4e6464e4,0x2c466332,0x325b9c89,0x1adb22e4,0x5c53d7bc,0xd1bb1a4,0x5e22c9ee,0x39d5ebce,0x6f9f32af,0x35314a4,0x756b8966,0x32136c0e,0x450e2237,0x491e037b,0x447b4513,0x5c965b25,0x474df13c,0x3a90c6c8,0x22389025,0x5b566d2c,0x1fe46a9f,0x5b4c5394,0x67848e6c,0x57f45ec2,0xc42e989,0x7e09c6ad,0x53696614,0x70a6836,0x7a796c80,0x12004d77,0x37ae0d81,0x3b12e2c3,0x2aeee2b2,0x30b17510,0x6d5c81cd,0x493f3d3b,0x315c81a7,0x458e11cf,0x6f7d5a6,0x2f666189,0x703cfd28,0x28f8dbf3,0x6a1cc2f,0x6bd3154,0x326365a7,0x64d54a4d,0x3941d0cd,0x332a117d,0x27c9acc1,0x249128c8,0x6be40ce7,0x3e79008,0xad3e27a,0x26307464,0x7e9a3348,0xd9fc14b,0x4bacbb21,0x678be316,0x6e268da6,0x45a42228,0x55da4a67,0x74c05ac0,0x69806172,0xb1c2fb8,0x3d9eba6c,0x170cf0b9,0x6f66ba7f,0xac7a1eb,0x6c7bab31,0x5e70493d,0x6db6dccb,0x74c54f3,0x5e32c85b,0x67a93cfd,0x4744627a,0x110c2c4f,0x4ac7aa1c,0x1fbf99df,0x60d3771e,0xfe06c43,0x7ce5b91f,0x608c0ce7,0x649193ae,0x92ff6f6,0x56f498e0,0x1d96c6f6,0x398d6829,0x61905888,0x1b777d5a,0x5abc4dd0,0x2cb5c724,0x4382e48,0x641df76f,0x5e3a64a0,0x19e9fc38,0x42a3bf5f,0x47b0aece,0xe914e2f,0x6fb5cba8,0x276a79fe,0x1a63ab88,0x53d9eb42,0x23a7017c,0x68e7098c,0x627e288f,0x327331f7,0x52e0d598,0xe0454da,0x3d614587},
    {0x693fedab,0x7bd1a108,0x3bcdd826,0x762ea7a,0x331af0,0x48dd74d6,0x596d1bdd,0xe889c21,0x3779dbab,0x2dba9eb7,0x77a2bd2d,0x26adc2e,0x6b411a98,0x17c1ea7,0x1496b13e,0x128e32f1,0x574f6387,0x5c9f5576,0x282f1fce,0x7d0ec231,0x84d10aa,0x5586bac9,0x496d5d34,0x1a331642,0x7bc12463,0x6e1af3a4,0x3c262b9b,0x714b9be1,0x367bcae1,0x5c1a13b,0x41e3fd12,0x64ae1916,0x1f36de47,0x147870bb,0x7defceeb,0x1ca5ca04,0x2af4c163,0x42a2f95a,0x41eb080d,0x619f3a8a,0x165caa65,0x4f364d9a,0x68db4ef0,0x70c298be,0x5b75e339,0x5d23a245,0x433dbbb4,0x7af4be16,0xa085045,0x3f030782,0x70835c66,0x5aa9d300,0x419a9b0c,0x2e55ce5e,0x7834d914,0x6976aeab,0x6d1e85cc,0x4aee9f0c,0x588fafa0,0x4874c495,0x588caf6d,0x3cf3a186,0x1fbe2ba,0x173d637a,0x145edb9f,0x34a6ba1b,0x209e47ac,0x3f50d186,0x78e5ad9c,0x49dcd539,0x6890de87,0x45673142,0xd9b61c6,0x20bc19aa,0x74ef9cd,0x6845b69d,0x79f5b731,0x3ed364fe,0x5e7b3218,0x47d12054,0x4cdccdd2,0x1a2794f9,0x329a6140,0x6f860acf,0x63587bad,0x5200f500,0x433202fc,0x5e409e29,0x315601cd,0x463b76b9,0x6ec3a8c1,0x4a556ee8,0x15450f55,0x4f56ec30,0x5ce6e091,0x19a89b5a,0x5b88a8d9,0x63586604,0x21be440e,0x27ad7f53,0x4dc7c363,0xa50846b,0x569a3aa5,0x59ccd064,0x706ebbf6,0x7d42b2fc,0x777992cc,0xaf492ab,0x5dbb941,0x38ed6565,0x7a6049dd,0x2438759e,0x1aa43384,0x1c19847f,0x71e6b9b8,0x4f13ffa0,0x33e4bf6d,0x9a859e0,0x5e5e9104,0x49a33073,0x56c4f0f,0x2c207094,0x45916bf4,0x777a855b,0x76577131,0x767da7f6,0x5b92e039,0x7c39f6a,0x4e88959,0x2f12befc,0x7cc4041f,0x4fca38dd,0x517e6bfd,0x7cb12d8f,0x1d0f20f4,0x187fd47f,0x1bdecd1e,0x11f66436,0x63296f91,0x1d8a0663,0x1f07225c,0x507d031e,0x1e0f11b3,0x35c868c2,0x42a5a38d,0x559f29cc,0x6619c3cc,0x6e93a59c,0x4b77c653,0x31ffc9ed,0x283e7206,0x3eeddcd5,0x144a34c7,0x7ad60157,0x3ea74f6c,0x1006032c,0x5b44863f,0x2697f8ae,0x9f01ebd,0x455067cb,0x7505c36c,0x2460049f,0x5123418a,0x53122b69,0x36a3f5e7,0x1c5ac67c,0x71cfc05d,0x62df9d56,0x310e0903,0x1b370501,0x58585d15,0x5b734ad1,0x5d3a40f8,0x5222a9e9,0x50b48b5c,0x2b0fae0a,0x39372336,0x318d08c4,0x341e3838,0x6eda9e44,0x7f174258,0x7035028b,0x36f4f78,0x628ea994,0x2967f56c,0x7632ce38,0x3ae8ffdd,0x79cea9b4,0x2a7e3d45,0x27fe363d,0x6adb97a1,0x37b883db,0x32fa11cb,0x3bd951e3,0x3fc4d9d3,0x70703356,0x1df005bd,0x303054b7,0x1801e7dc,0x1d638955,0x58bd2c21,0x65582fb7,0x43230558,0x2392b5fa,0x7e01d4c2,0x14ac5e50,0x5d3b0ecc,0x50be9190,0x69609e8b,0x5def30bb,0x17e45b49,0x1cd301eb,0x3f50aa85,0x4514b68a,0x7a4d512b,0x41358335,0x9fc5aca,0x194f7e04,0x710ed612,0x6d62ae91,0x610c99ad,0xb0fded4,0x9194d0f,0x2803553e,0x138aae05,0x1bbaff50,0x696843a1,0xed97e0,0x2973fa83,0x6be663a0,0x1c676cf2,0x6214db6e,0x6a344204,0x4f77564a,0x2534ea8f,0xc64198b,0x63d8ca1b,0x4c94971a,0x3bece20d,0x63f7a820,0x5022cb39,0x4efcb322,0x54a2041,0x4d1f3596,0x620e6899,0x200f0c5a,0xe6a8e31,0x256268b0,0x5674c84,0x34a2e505,0x3e5730e9,0x6c2311f0,0x4beda19b,0x22e1095f,0x1bf9d9e6,0x7b864b5c},
    {0x5a7506f,0x68443ee1,0x4c4b35c9,0x6d0c43d1,0x3ef73cf3,0x75f9b8b9,0x2e1b7b14,0x4a8a0063,0x7c90cc4a,0x8d7aaa5,0x26c8c94d,0x1c18f633,0x1d9b7975,0x7494d5e4,0x1480bce5,0x321e1dde,0x5f4a0f27,0x2349d74e,0x5323a70b,0x368a5a20,0xe96abd0,0x901ee9,0x1586d86c,0x7e171814,0x60801e82,0xce3b2d5,0x89fa57e,0x23fbb2f,0x77fd983a,0x5a7df8dc,0xec8527f,0x35623797,0x714e2ae3,0x78f735eb,0x354c5bfa,0x3b7fa0e,0x170acbbc,0x35824e1c,0x77cfb89d,0xd60db55,0x34b03c87,0x1767c790,0x615da3ca,0x77ed9f06,0x1b847d06,0x52afac73,0x775bf99,0x6e233d47,0x62e58321,0x545e21b6,0x597df0c6,0x79660c42,0x56fc6e2d,0x9a90e39,0x5a4a9a86,0x7f2245c4,0x15a32614,0x6cc7fc50,0x309db74b,0x6f17a095,0xacad100,0x53b42b2d,0x11057486,0xcca39ac,0x52e7f21d,0x585b3f86,0x5fee7254,0x34370632,0x73de6de1,0x729e25c7,0x4ede403e,0x37fc4e4a,0x777bb50d,0x3b0fd3b6,0x11c65e75,0x7549f9c8,0x9d90231,0x560bc5bf,0x74ddead4,0x68b56fc3,0x58e85219,0x11e6cb26,0x586aaa44,0x7770258,0x741c838a,0x6946fe7e,0x5cab3399,0x44f2bc62,0xa2f4961,0x3591033c,0x43736aff,0xfeed175,0x52e35f0,0x70079952,0x92c5da7,0x6acae651,0x26f34571,0x6a5592b6,0xfed03b5,0x1c5dc773,0x6156040a,0x2c0dba8c,0x4c03c85a,0x102fb319,0x5482521f,0x3652103e,0x35e8829c,0x62f996bc,0x74a58af,0x4854a17c,0xb6dc0b8,0x3b4cf610,0x7c6023cb,0xaabde96,0x6f05df4a,0x2f948584,0x53abcc2c,0x28c6b0b2,0x413dc09e,0x556f0a1a,0x32cb44b9,0x684207fa,0x74aae5c0,0x2ac869e9,0x4d11265a,0x29349fae,0x179749b8,0x1f0a7b3b,0x5030a3c3,0x2272a34a,0xb4e7899,0x4d94ed82,0x7be381c8,0x3a1046ea,0x48a2fd1a,0xc121b0f,0x74d5655,0x61616b78,0x222e851e,0x63872365,0x43c2ac45,0x3fe38d29,0x4be08d19,0x5b3d8e88,0x8ee64c7,0x1ac8b49d,0x7ea18443,0x1eaed1f4,0x4426235a,0x21c7f4a,0x79cdb130,0x72ee4050,0x7edace99,0x5360d217,0x7f0a42e,0x1e3c59ce,0x19575cfa,0x2a080b4,0x2d126717,0x3cd5ff0f,0x6fc914ca,0x5a92906b,0x6e0e1b86,0x3e023ada,0x3bd2dadd,0x63b2977a,0x1e8b6d47,0x256282ab,0x7334a339,0x7255f81d,0x646d40b1,0x7cadbd9d,0x1e297663,0x74948b34,0x142e8362,0x217abd,0x1f55c54d,0x30ef59fa,0x29222a4c,0x17b026e5,0xc3029db,0x117f7089,0x7d4b3228,0x7b126156,0x546f6587,0x13d467e7,0x1835e3b3,0xb232b38,0x162d690c,0x3d7f678f,0x4c07bde3,0x4a116863,0x2889d775,0x55b76b32,0x707a198,0x6ec84849,0x3685099e,0x68abba78,0x5ffe6195,0x6fc414f6,0x18af097f,0x4857e7c0,0x4946bcff,0x79372db0,0x5e5da877,0x5e3a331f,0x1cae2144,0x6147d81,0x585c1d2f,0x6e3d8595,0x413cb596,0x5f43b472,0x9729af0,0x61dc5f42,0x5c15f689,0x5d2afee9,0x264211ff,0x7c790162,0x7085f50d,0x7f4bb5a4,0x2543ab4a,0x3e45d85e,0x398af0fc,0x609fa225,0x8a7b27b,0x8445675,0x5ad04702,0x35c753ca,0x7b9091a6,0x451d9a14,0x5b95f567,0x51eb6386,0xfef94da,0x589923b8,0x1b9bd83,0x50873157,0x29c4d62d,0x49f05574,0x474e84bd,0x3a5cf0a0,0x2d7012f6,0x6a6ba440,0x6e0bb1bf,0x536b3f40,0x3ec410df,0x1511f6be,0xd69d772,0x56835461,0x57379f44,0x23c34414,0x15abe244,0x3fc52ba5,0x8d2d8cc,0xf4d6fb8,0x590926b1,0x580dafc3},
    {0x274bb9f9,0x31bdb95b,0x783713ef,0x4ff7ffed,0x4316778d,0x7ed9523,0x26c04b73,0x5359fa07,0x572ab6a7,0x67a90398,0x6f9f70d8,0x17e8eb6a,0x355cc4a3,0x5828f3b2,0x28286a18,0x2b6d93ea,0xfda4fa,0x6f46507d,0x568f1e88,0x7ab950fb,0x76c4aac0,0x29f39b96,0x247e1e42,0x5d8e4792,0x4f82d258,0x5dd56277,0x7a02604b,0x24cc24cc,0x6be3f6e4,0x6854264f,0x4ba917e3,0x3b4eaf3a,0x4b0f325d,0xe5501d1,0x5708acb3,0x7f5fe2ad,0x7ffec228,0x1517e8ca,0x1e234f3,0x7954546f,0x68443de8,0x6bebe13f,0x52f36e85,0x7c4c7034,0x71330002,0x4f934b46,0x1fb35135,0x2eaeed70,0x163ce612,0x316d7fc2,0x49b3a36e,0x1cc99541,0x1db59d20,0x7a3a9814,0x48699815,0x12f152aa,0x3e83348e,0x6a59ac64,0x590f2695,0x6246076e,0x47d25d1,0x41af1bc7,0x33220ed1,0x53db2317,0x6780fc05,0x3351bd84,0x7fb6d3f,0x3e28e7fe,0x1f931821,0x4cae6c8b,0x2b13d159,0x2126d1ec,0x40bf6d94,0x3545fbe2,0x37e13cc7,0x6882fb3c,0x622165ff,0x329f34d5,0x3a8f9e9b,0x786964d2,0x337231f3,0x45b8749d,0x417b18de,0x3ab5b00e,0x25ae1fb,0x66e2e891,0x4b0c5a50,0x7bd64bcf,0x13e50a6,0x14dd671c,0x41f10203,0x15861060,0x55fff278,0x2e8260ca,0x61a505a7,0x61435c8,0x4332a497,0x4b07f456,0x199b135a,0xdf9d934,0x16b9e141,0x61590d94,0x786f5fbc,0x7389359c,0x79eb5528,0x574fb2e3,0x5cced83,0x2000994c,0x2d092b72,0x70b23fd1,0x71cc53a2,0x4b16ff9,0x492cdc38,0x2d9014f1,0x20d6955d,0x37e97719,0x2e058b7e,0x16349584,0x10a46618,0x4425f3df,0x165be840,0x7950d3c,0x39785fd3,0x31f93f54,0x3ac871b7,0x472bf3ad,0x1903494,0x5897abb6,0x397b1e2b,0x713ebc8e,0x60610e48,0x35783236,0x71b404af,0x3cc6dca8,0x41a25e32,0x79a02686,0x6c8234b8,0x469b3376,0xfb1c082,0x1ab02ada,0x7f4c6b66,0x5f48d2d4,0x3d13158f,0x4f6c4c58,0x2a424605,0x29fe0fb8,0x41128647,0x2cc5b88f,0x2f60cadf,0x14bae6ef,0x5ac99be2,0x1ffa1a1d,0x6ccfef6d,0xf6d334a,0x454f84bf,0x34b72f43,0x5a19cc84,0x6cd17673,0x2878df5f,0x2b22a713,0x55081d91,0x35bc03ec,0x3d3c98be,0x7788e777,0x98609e4,0x5b45a95b,0x3068455,0x4291b6d9,0x20c1ed69,0x506f5ad4,0x2b351424,0x4f4f110b,0xcec2832,0x66ec50de,0x75e83995,0x1eba5503,0x69396e1f,0x1dc4fb6b,0x6c36032,0x2c68a0da,0x1f0438b5,0x6334d4d2,0x718c924e,0x7a9f0505,0x925f6a9,0x79198d9c,0x7b79880b,0x3fab6967,0x5ab98d09,0x7416d918,0x6f663,0x41234ba6,0x76b341bb,0xd94519d,0x6e25ab39,0x7a6429c2,0x206a0ac,0x78b07204,0x37284a96,0x4e798d4b,0x41758a9f,0x1a95c5ab,0x66390b54,0x6deee9ef,0x2b2a3b4b,0x7a90557f,0xd886efe,0x50b1bd52,0x2961142d,0x2605943e,0x5faaefbb,0x6d2388d8,0x3e5fde1d,0x75050c10,0x734076e4,0x4c608859,0x5a366b63,0x422f5025,0x5e55846d,0x3e08ef94,0x7a9203c7,0x20ca095f,0x6e0c7a7b,0xecaeaa4,0x4d3a2bc8,0x5070d92,0x4d6c263f,0x5653608d,0x3996bdf4,0x6f7d54fc,0x33905cbc,0xbda3dad,0x7a9a5fe6,0x7f72e20f,0x7babe122,0x40811d75,0x72835664,0x15df0f40,0x62d25827,0x5d9782e8,0x698a612c,0x3df36285,0x29c5fcf5,0x78ff4e82,0x10b8c8c1,0x7ef9cd6b,0x19da5d84,0x3f8081f0,0xc650b45,0x4cfc9e01,0x6493667c,0xcde544b,0x24c9acc6,0x255b4a1c,0x120d0b73,0x3761acd0},
    {0x4143b637,0x1296b1d0,0x4a78778a,0x7da57f8d,0x4818003b,0x39733ee5,0x1cbaa693,0x481d887e,0x178a6e43,0x6567af22,0x80c40f1,0x34c4bd30,0x6d23e30e,0x1c4912d1,0x7d7c8a4c,0x459d00d5,0x26342d2b,0x4052b9f3,0x759a1aee,0x12995d38,0x30c1be57,0x5ea7b80f,0x74950f1e,0x1829c806,0x4ed853a1,0x3f8e34ff,0x5267cfb3,0x7341fafa,0x701f101b,0x4c35d0fe,0xe5d924f,0x792a5fb6,0x1ca76cf0,0x7cb0d0a9,0x7f678435,0x4977a427,0x77164916,0x3097e2f1,0x74418f8e,0x3c3d15c4,0x6345a1a,0x263fa41f,0x140a7fb6,0x63985114,0x5894967a,0x39c20df,0x305106bb,0x2e7ab299,0x6ffbece5,0x65fecff2,0x41b525cb,0x366f2ff1,0x1a27bcd4,0x3cd989a9,0x3d41eb05,0x688a257f,0xc764e59,0x1929911c,0x2bb94294,0xff58b84,0xa35a693,0x3478e99b,0x4939f86e,0x2771993f,0x6e83c18c,0x7d745c28,0x115c557c,0x7b3b2ac8,0x3dca3b4b,0x45a38193,0x24534703,0x21c5bca8,0x50c5e7e1,0x518e31de,0x18778383,0x3f085fd7,0x529d7a68,0x51c9c088,0x30ff2b10,0x75cb109d,0x28aabd9e,0x5f1fb5a0,0x1c436725,0x6d78366d,0x28042cce,0x778c58ef,0x2ec97fce,0x6f017b54,0x3d281b16,0x3553da4f,0x28742668,0x64df186,0x5ef1068d,0x52be243d,0x1f162ff3,0x13f8ff2a,0x26f447ec,0x68aae881,0x3b2ca670,0x7c26ae23,0x75747c8d,0x74325724,0x7282f573,0x6617259e,0x39d1f827,0x69187766,0x382c773f,0x1aee1b6c,0x7c311e95,0x7c0f8b66,0x47cceb90,0x791a2bab,0x3067cef5,0x6dc9545b,0x3a27f15d,0x67ad9e47,0x3d4b50a2,0x53a79cba,0x68c9a570,0x2eb8b47f,0x2d15fa70,0x4bfc583f,0x73361137,0x18ee4060,0x4667dc3a,0x116a4831,0x64a97edc,0x373eeb2,0x2d784ed2,0x19a4eba0,0x7cc39a9c,0x53fd28a9,0x4dbc81b,0x55731a1d,0x34c18e59,0x19cda979,0x218cd9d1,0x281229ea,0x579cf59,0x25c4c0e0,0x62242152,0x1b04b7f5,0x1b7a7ef8,0x460304ca,0x41fed40c,0x67a6a63b,0x8802aab,0x66632881,0x53d41d6e,0x7e557176,0x1366ab4b,0x69b58d99,0x21cc94f2,0x52153009,0x552649b2,0x1bbd0101,0x59a438d4,0x657c1684,0x469c7745,0x7949a6f8,0x16e9354,0x4ee1f205,0x1e183d09,0x6c20e57b,0x5200fc44,0x17b642f5,0x69ad02a6,0x53239884,0x1e581520,0x3272ef00,0x58fbcc42,0x3c32a59d,0x6e5c8fe5,0x5afa024,0x43756226,0xe61955b,0x31aa7d1b,0x2cf253f6,0x4cb44aeb,0x693caf57,0x626c7ebc,0x7af43189,0x1bcdfb0b,0x66a41be9,0x41175d78,0x3d0c0ab0,0x29e99d44,0x1ee9ce8c,0x20bf,0x57341e1d,0x6e99625a,0x44764263,0x76224abc,0x43e8f40e,0x223bb46d,0x68b44ebf,0x3d052f51,0x4456abef,0x2b5337dc,0x1b9a582c,0x6cb07732,0x1f39820c,0x66bd9813,0xa561f2f,0x40ca11e3,0x728ff69a,0x4b33c73e,0x7e9af377,0x51296cd1,0x5c09cefc,0x30e437e3,0x29b265c0,0x3ffb5fed,0x37e981d5,0x69a63fe3,0x45a32d48,0x6a38e351,0x6bd3db1,0x5afa1cd4,0x352cb33b,0x3a00ae2a,0xd6a328,0x4e92e448,0x1e871615,0x21be866f,0x440bff5f,0x398451bf,0x6d5108bb,0x4ff6acf3,0x780e899c,0x290fa4a6,0x3b3249ea,0x107bf5dd,0x734f9c9e,0x72ad2e84,0x6300466c,0x6e847e85,0x311cc56d,0x20645902,0x469100b1,0x75e7fba2,0x1754ed1a,0xb78c3d8,0x61219a02,0x77f93409,0x6b1f8dc,0x68b692d8,0x3f7b4128,0x2f950e19,0x6fac3468,0x29d53c9,0x357574ee,0x160d27a9,0x778b2d33,0x1a9e9465,0x5cd6f503},
    {0x26979695,0x62740e4c,0x3af9f6b3,0x1899c06a,0x7a2e8c38,0x58790054,0x45d78a28,0x1bd5f571,0x6e26fe96,0x4844e2f3,0x14e84594,0x3ae50efb,0x14992c3e,0x76c25177,0x6c7cb4c5,0x5d4df880,0x47f9d8e2,0x53bc12b9,0x31f5317e,0x5af066bd,0x518bca90,0x4f984625,0x6ba4aad5,0x50efd2be,0x1cfde16f,0x36aea17b,0x3eff3c1e,0x4b43bb7c,0x36cc0711,0x4f17b83a,0x7ff4e9b4,0x1fcf900d,0x3816bde9,0x4c9649ef,0x6e18b7c4,0x2b3ac282,0x40be42d7,0x667fc6a9,0x200dd4c1,0x3cc6642b,0x1d668eac,0x71854ec1,0x69b86af,0x7c15f0a4,0x42971e4a,0x67be9ec3,0x4f1319e2,0x122b4d57,0x3675755,0x6f931646,0x69b4f3f8,0x1d7662c,0x31f32929,0x1c150847,0x12b881f8,0x14eaefcf,0x554b0843,0x6ebc16d3,0x2f3022f1,0x1fe67d74,0x639295ec,0x135794d6,0x5a9aeb65,0x7857e3c,0x1a6ab4e9,0x59b0a686,0x14d7519a,0x40aa81c2,0x2297a6b2,0x69e11be0,0x8695678,0x122cd5c3,0x2809709f,0x6e953bfa,0x3b9bd645,0x61c597ba,0x51bc5070,0x64e16ff7,0x215762e1,0x6c23c9a0,0x3588675,0x6b0bc07e,0x4715639e,0x732238af,0x57dfc10,0x6ccedbba,0x2850f583,0x3ca666ee,0x3ee7210d,0xe373ac1,0x1482bbeb,0x36cad1bc,0x22d11885,0x7a289fe2,0xb753fea,0x68fa0494,0x19eeca3d,0x660575df,0x4dadebc6,0x9e1916a,0x1834a4a3,0xa4d0330,0x50b3be15,0x72723d32,0x7642c369,0x6e740659,0x3197816b,0x68eb040a,0x12520b26,0x9f005c5,0x6040b30a,0x1c7dff49,0x59394d67,0x2a51b287,0xbc6b17b,0x28a17e97,0x1e4892af,0x5d37e5c,0x4866fcad,0x10571df8,0x2e43a363,0x2b892102,0x4af88851,0x706d3954,0x50d1d19f,0x548fdae4,0x78bc3b72,0x2fd9640c,0x34a52949,0x14c92941,0x33ca7f3c,0x456d5dc9,0x225cb2c3,0x7d4b90b8,0x1d381357,0x54bdd486,0x5c04fd1b,0x12b706c5,0x10fa34eb,0x1a36bffa,0x337815f4,0x49c319ea,0x77da40ad,0x377ff507,0x82023b4,0x7e20264,0x60f059ed,0x3f82a3d4,0x1eace2b7,0x521d7c9,0x72728023,0xb226b19,0x60076c97,0x5873165b,0x431d159a,0x7cd63034,0x2872de8f,0x1b6bf91d,0x58ef7a95,0x4f78f0ec,0x672c6714,0x2871cc75,0x1a93e695,0x1b86cc9a,0x209c6c98,0x6f36cd34,0x752df26f,0x61623d93,0x25208a2c,0x189a4031,0x57f3fd5e,0x4c3e8595,0x75b4ef9a,0x47d612a1,0x4cc900e0,0x18c63665,0x69c54ad,0x3dd783db,0x7cf73070,0x33be064e,0x6f53f5bd,0x1e59fb47,0x76fbafa9,0x7fa941a1,0x4961488,0x7c3a939f,0x1fd83c46,0x3eeced9d,0x64663197,0x1cdfb470,0x36e6874b,0x39970f36,0xf5ed2cf,0x1f16eed5,0x70d7ff07,0x59d0888c,0x3d18a6dd,0x6eca7e41,0x56245288,0x5be938bd,0x277e3742,0x1cb4d93e,0x7d133618,0x61db1911,0x54059d80,0x13059944,0xe573a4b,0x2fe7c654,0x2ca5e36d,0x10af41f2,0x2c6bbdc1,0x6f992cfe,0x4e66d438,0xc028b44,0xe5eee35,0x7b882cff,0x42cde83c,0x7566c486,0x5bab497,0x18a92583,0x187c6929,0x3870d204,0x88f2ea1,0xb1198b8,0x136f2ed3,0x53374f52,0x588870e6,0xdef9f84,0x2e65a3e,0x3b82a61a,0x21303112,0x52e5d7ee,0x927ac7d,0x1d1ffbc8,0x272c15a3,0x28d05ee5,0x4a75929b,0x3437319,0x21e6e931,0x3ea23bf1,0x6c022372,0x798c3c0f,0x6726e60d,0x182d0587,0x7aae12f,0x1d2ed49d,0x24566c1c,0x6e09bd17,0x5bb59b3d,0x1c3127af,0x4d4355de,0x2f95dce1,0x7a7849e3,0xfd8ff70,0x1edd7e75,0x4707e679},
    {0x6b2540a2,0x43a8835,0x6ad2a0b9,0x41665595,0x23e2932c,0x6924e625,0x18a3a1b5,0x4539ee86,0x18b302b2,0x332d9490,0x38acd5e7,0x49ba2a42,0x12b3669c,0x4900aa3b,0x671de38c,0x5d4940b1,0x1ad94a24,0x3efb0ccd,0x36e44950,0x359d8c6b,0x43a0dc5f,0x4cac470f,0x16e82756,0x6e5ddf8e,0x7a3e1463,0x6fe5f9d3,0x73404e2,0x46f25ba7,0x49db2788,0x43ac0861,0x48d6a124,0x303c9768,0x3aa06758,0x73b165ee,0x3f44afa8,0x7e37e714,0x784d4e4b,0x7708b508,0x6c8e8c87,0x752a62f7,0x213685b7,0x59f7be70,0x10d532de,0xe06018b,0xc0b2a8c,0x30c45354,0x5255a32e,0x3cdf8bca,0x76fc3068,0x2cf7cc60,0x57bf62ea,0x52bbeb08,0x79ba082e,0x4731b67,0x1d41f7e2,0x5808c681,0x68a68976,0x16541be3,0x16319116,0x4ad7e8ef,0x11aaaf8d,0x5fa61d2e,0x7f06bdb7,0x340380c1,0x7aa56d97,0xcec53e7,0x4a4a7e03,0x60f4f553,0x1652a5fd,0x51d74661,0x41751db6,0x66bc65fe,0x164f0f27,0x765520f,0x747cb12d,0x6477899e,0x2101710f,0x5cda40dc,0x604796dd,0x54fb2eee,0xf3abb00,0x78a8df93,0x7e62d53a,0x4e75c1b0,0x7e2f3fe6,0x59d25c9c,0x6e3d277e,0x1458df8f,0x1e880585,0x7f6e5e,0x799cf590,0x62c4f5ac,0x45da2c67,0x47bd5170,0xabcc62b,0x39f7ddcd,0x7b9640ce,0x7f974e24,0x8052d60,0x28758965,0x6787a264,0x3eb0c2e0,0xd39a0,0x37433cf6,0x1f050511,0x272a2a50,0x504ec721,0x36d31a5,0x476c80ac,0x2b79344c,0x60335cbd,0x16028db0,0x40866acd,0x5297c8c7,0x75984e3b,0x5ae4de1b,0x524df1ac,0x74bcf957,0x247971c4,0x38bebb92,0x159078e7,0xc564e0c,0x2a95a106,0x7df5ec8b,0x48debb94,0x277bebb6,0x2e65b529,0x3f2b33a6,0x56725b0b,0x20d92dbb,0xf748afb,0x540e23a0,0x28303c6c,0xaaaa460,0x1d89ad20,0x3c77e08b,0x1e01130,0x663433cf,0x575d40af,0x6d396af7,0x3e21a430,0x652aa290,0x57a64fbf,0x56d3d530,0x7d445ef9,0x6f820645,0xb2c6a79,0x278de69f,0x20f411f7,0x4aa68900,0x11a2baed,0xcfb86aa,0x691d755e,0x2bba65d1,0x1801b040,0x542dd028,0x2ccca308,0x5829d9aa,0x1a6b36d0,0x7eb35813,0x4956b114,0x7f18d0ab,0x754d0113,0x50c43c7,0x20eadfa4,0x6b34252e,0x3f115d7f,0x6efd8451,0x26f35dc0,0x31f85e48,0x26efbfd1,0x66fe107d,0x2af3f9ed,0x78125d07,0x76026b35,0x2264beae,0x7e0515e8,0x2a43bcad,0x30b10528,0x47a889ad,0x14e5cdd8,0x52496be6,0x36a795a7,0x7c762444,0x10a69f61,0x3a3eb67a,0x3c06bf54,0x41d074ea,0x13ff49b9,0x5d4fb264,0x524fbaa6,0x7ef00ccd,0x76f2f45f,0x4d2506f1,0x6b09e12c,0xa2d5460,0x6360e164,0x37ef470c,0x9be20fa,0x71b9c1d4,0x7bf70fbc,0x249cc417,0x5c0caf1d,0x45f711c8,0x3e0308ca,0x11dd34e4,0x682bff4e,0x622addde,0x51cd299,0x746b14e6,0x431f03c5,0x368f65b0,0x6255d843,0xac114e9,0x6ab19bb8,0x68540dc0,0x4e779009,0x7708e880,0x7eb83744,0xb748c43,0x2202f6bc,0x36522a71,0x5292be11,0x7847531e,0x4ee04443,0x5af97cdf,0x98a868c,0x182daa9b,0x6c64e6b9,0x642b259b,0x3fe28fe1,0x575fab00,0x6b4c2c8d,0x60c8fd11,0x4f7d333b,0x403f48de,0x241d557d,0x7039e908,0x20c34228,0x668d9575,0x6c718bc2,0x52fe36df,0x1314dc06,0x308d0,0x10bad1fe,0x7ffa9668,0xcc0ac97,0x60641db9,0x624fbca4,0x1bd4408d,0x12f7d27b,0x264dbd2a,0x72306bca,0x41e2682c,0x2f309b4e,0x295aeed6}
};
*/
/*
uint64 g_ZobristLockTable[10][90]=
{
	{//
     U64(0x9d39247e33776d41),U64(0x2af739805aaa5c7),U64(0x44db015024623547),U64(0x9c15f73e62a76ae2),U64(0x75834465489c0c89),U64(0x3290ac3a203001bf),U64(0xfbbad1f61042279),U64(0xe83a908ff2fb60ca),U64(0xd7e765d58755c10),
     U64(0x1a083822ceafe02d),U64(0x9605d5f0e25ec3b0),U64(0xd021ff5cd13a2ed5),U64(0x40bdf15d4a672e32),U64(0x11355146fd56395),U64(0x5db4832046f3d9e5),U64(0x239f8b2d7ff719cc),U64(0x5d1a1ae85b49aa1),U64(0x679f848f6e8fc971),
     U64(0x7449bbff801fed0b),U64(0x7d11cdb1c3b7adf0),U64(0x82c7709e781eb7cc),U64(0xf3218f1c9510786c),U64(0x331478f3af51bbe6),U64(0x4bb38de5e7219443),U64(0xaa649c6ebcfd50fc),U64(0x8dbd98a352afd40b),U64(0x87d2074b81d79217),
     U64(0x19f3c751d3e92ae1),U64(0xb4ab30f062b19abf),U64(0x7b0500ac42047ac4),U64(0xc9452ca81a09d85d),U64(0x24aa6c514da27500),U64(0x4c9f34427501b447),U64(0x14a68fd73c910841),U64(0xa71b9b83461cbd93),U64(0x3488b95b0f1850f),
     U64(0x637b2b34ff93c040),U64(0x9d1bc9a3dd90a94),U64(0x3575668334a1dd3b),U64(0x735e2b97a4c45a23),U64(0x18727070f1bd400b),U64(0x1fcbacd259bf02e7),U64(0xd310a7c2ce9b6555),U64(0xbf983fe0fe5d8244),U64(0x9f74d14f7454a824),
     U64(0xae4a9346cc3f7cf2),0,U64(0x1920c04d47267bbd),0,U64(0x87bf02c6b49e2ae9),0,U64(0x92237ac237f3859),0,U64(0xff07f64ef8ed14d0),
	 U64(0x8de8dca9f03cc54e),0,U64(0x9c1633264db49c89),0,U64(0xb3f22c3db0b38ed),0,U64(0x390e5fb44d01144b),0,U64(0x5bfea5b4712768e9),
	 0,0,0,U64(0x1e1032911fa78984),U64(0x9a74acb964e78cb3),U64(0x4f80f7a035dafb04),0,0,0,
	 0,0,0,U64(0x6304d09ab3738c4),U64(0x2171e64683023a08),U64(0x5b9b63eb9ceff80c),0,0,0,
	 0,0,0,U64(0x506aacf489889342),U64(0x1881afc9a3a701d6),U64(0x6503080440750644),0,0,0
	},
	{//ʿ
		0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,
        0,U64(0xdd2c5bc84bc8d8fc),0,0,0,0,0,U64(0x7eed120d54cf2dd9),0,
		0,0,0,0,0,0,0,0,0,
        U64(0x22fe54541165f1c),0,0,U64(0xdec468145b7605f6),U64(0xc91800e98fb99929),U64(0x1bede3a3aef53302),0,0,U64(0x808bd68e6ac10365),
        0,0,0,0,U64(0x43539603d6c55602),0,0,0,0,
		0,0,U64(0xa87832d392efee56),U64(0xaa969b5c691ccb7a),0,U64(0x65942c7b3c7e11ae),U64(0xded2d633cad004f6),0,0	
	      
 	},
	{//
     U64(0x4850e73e3eb6064),U64(0xcfc447f1e53c8e1b),U64(0xb05ca3f564268d99),U64(0x9ae182c8bc9474e8),U64(0xa4fc4bd4fc5558ca),U64(0xe755178d58fc4e76),U64(0x69b97db1a4c03dfe),U64(0xf9b5b7c4acc67c96),U64(0xfc6a82d64b8655fb),
     U64(0x9c684cb6c4d24417),U64(0x8ec97d2917456ed0),U64(0x6703df9d2924e97e),U64(0xc547f57e42a7444e),U64(0x78e37644e7cad29e),U64(0xfe9a44e9362f05fa),U64(0x8bd35cc38336615),U64(0x9315e5eb3a129ace),U64(0x94061b871e04df75),
     U64(0xdf1d9f9d784ba010),U64(0x3bba57b68871b59d),U64(0xd2b7adeeded1f73f),U64(0xf7a255d83bc373f8),U64(0xd7f4f2448c0ceb81),U64(0xd95be88cd210ffa7),U64(0x336f52f8ff4728e7),U64(0xa74049dac312ac71),U64(0xa2f61bb6e437fdb5),
     U64(0x4f2a5cb07f6a35b3),U64(0x87d380bda5bf7859),U64(0x16b9f7e06c453a21),U64(0x7ba2484c8a0fd54e),U64(0xf3a678cad9a2e38c),U64(0x39b0bf7dde437ba2),U64(0xfcaf55c1bf8a4424),U64(0x18fcf680573fa594),U64(0x4c0563b89f495ac3),
     U64(0x40e087931a00930d),U64(0x8cffa9412eb642c1),U64(0x68ca39053261169f),U64(0x7a1ee967d27579e2),U64(0x9d1d60e576f5b6f),U64(0x3810e399b6f65ba2),U64(0x32095b6d4ab5f9b1),U64(0x35cab6219dd038a),U64(0xa90b24499fcfafb1),
     U64(0x77a225a07cc2c6bd),U64(0x513e5e634c70e331),U64(0x4361c0ca3f692f12),U64(0xd941aca44b20a45b),U64(0x528f7c862c5807b),U64(0x52ab92beb9613989),U64(0x9d1dfa2efc557f73),U64(0x722ff175f572c348),U64(0x1d1260a51107fe97),
     U64(0x7a249a57ec0c9ba2),U64(0x4208fe9e8f7f2d6),U64(0x5a110c6058b920a0),U64(0xcd9a497658a5698),U64(0x56fd23c8f9715a4c),U64(0x284c847b9d887aae),U64(0x4feabfbbdb619cb),U64(0x742e1e651c60ba83),U64(0x9a9632e65904ad3c),
     U64(0x881b82a13b51b9e2),U64(0x506e6744cd974924),U64(0xb0183db56ffc6a79),U64(0xed9b915c66ed37e),U64(0x5e11e86d5873d484),U64(0xf678647e3519ac6e),U64(0x1b85d488d0f20cc5),U64(0xdab9fe6525d89021),U64(0xd151d86adb73615),
     U64(0xa865a54edcc0f019),U64(0x93c42566aef98ffb),U64(0x99e7afeabe000731),U64(0x48cbff086ddf285a),U64(0x7f9b6af1ebf78baf),U64(0x58627e1a149bba21),U64(0x2cd16e2abd791e33),U64(0xd363eff5f0977996),U64(0xce2a38c344a6eed),
     U64(0x1a804aadb9cfa741),U64(0x907f30421d78c5de),U64(0x501f65edb3034d07),U64(0x37624ae5a48fa6e9),U64(0x957baf61700cff4e),U64(0x3a6c27934e31188a),U64(0xd49503536abca345),U64(0x88e049589c432e0),U64(0xf943aee7febf21b8)
	},
	{//
     U64(0x6c3b8e3e336139d3),U64(0x364f6ffa464ee52e),U64(0xd60f6dcedc314222),U64(0x56963b0dca418fc0),U64(0x16f50edf91e513af),U64(0xef1955914b609f93),U64(0x565601c0364e3228),U64(0xecb53939887e8175),U64(0xbac7a9a18531294b),
     U64(0xb344c470397bba52),U64(0x65d34954daf3cebd),U64(0xb4b81b3fa97511e2),U64(0xb422061193d6f6a7),U64(0x71582401c38434d),U64(0x7a13f18bbedc4ff5),U64(0xbc4097b116c524d2),U64(0x59b97885e2f2ea28),U64(0x99170a5dc3115544),
     U64(0x6f423357e7c6a9f9),U64(0x325928ee6e6f8794),U64(0xd0e4366228b03343),U64(0x565c31f7de89ea27),U64(0x30f5611484119414),U64(0xd873db391292ed4f),U64(0x7bd94e1d8e17debc),U64(0xc7d9f16864a76e94),U64(0x947ae053ee56e63c),
     U64(0xc8c93882f9475f5f),U64(0x3a9bf55ba91f81ca),U64(0xd9a11fbb3d9808e4),U64(0xfd22063edc29fca),U64(0xb3f256d8aca0b0b9),U64(0xb03031a8b4516e84),U64(0x35dd37d5871448af),U64(0xe9f6082b5542e4e),U64(0xebfafa33d7254b59),
     U64(0x9255abb5d532280),U64(0xb9ab4ce57f2d34f3),U64(0x693501d628297551),U64(0xc62c58f97dd949bf),U64(0xcd454f8f19c5126a),U64(0xbbe83f4ecc2bdecb),U64(0xdc842b7e2819e230),U64(0xba89142e7503b8),U64(0xa3bc941da5061cb),
     U64(0xe9f6760e32cd8021),U64(0x9c7e552bc76492f),U64(0x852f54934da55cc9),U64(0x8107fccf64fcf56),U64(0x98954d51fff6580),U64(0x23b70edb1955c4bf),U64(0xc330de426430f69d),U64(0x4715ed43e8a45c0a),U64(0xa8d7e4dab780a08d),
     U64(0x572b974f03ce0bb),U64(0xb57d2e985e1419c7),U64(0xe8d9ecbe2cf3d73f),U64(0x2fe4b17170e59750),U64(0x11317ba87905e790),U64(0x7fbf21ec8a1f45ec),U64(0x1725cabfcb045b00),U64(0x964e915cd5e2b207),U64(0x3e2b8bcbf016d66d),
     U64(0xbe7444e39328a0ac),U64(0xf85b2b4fbcde44b7),U64(0x49353fea39ba63b1),U64(0x1dd01aafcd53486a),U64(0x1fca8a92fd719f85),U64(0xfc7c95d827357afa),U64(0x18a6a990c8b35ebd),U64(0xcccb7005c6b9c28d),U64(0x3bdbb92c43b17f26),
     U64(0xaa70b5b4f89695a2),U64(0xe94c39a54a98307f),U64(0xb7a0b174cff6f36e),U64(0xd4dba84729af48ad),U64(0x2e18bc1ad9704a68),U64(0x2de0966daf2f8b1c),U64(0xb9c11d5b1e43a07e),U64(0x64972d68dee33360),U64(0x94628d38d0c20584),
     U64(0xdbc0d2b6ab90a559),U64(0xd2733c4335c6a72f),U64(0x7e75d99d94a70f4d),U64(0x6ced1983376fa72b),U64(0x97fcaacbf030bc24),U64(0x7b77497b32503b12),U64(0x8547eddfb81ccb94),U64(0x79999cdff70902cb),U64(0xcffe1939438e9b24)
	 },
	 {//
     U64(0x829626e3892d95d7),U64(0x92fae24291f2b3f1),U64(0x63e22c147b9c3403),U64(0xc678b6d860284a1c),U64(0x5873888850659ae7),U64(0x981dcd296a8736d),U64(0x9f65789a6509a440),U64(0x9ff38fed72e9052f),U64(0xe479ee5b9930578c),
     U64(0xe7f28ecd2d49eecd),U64(0x56c074a581ea17fe),U64(0x5544f7d774b14aef),U64(0x7b3f0195fc6f290f),U64(0x12153635b2c0cf57),U64(0x7f5126dbba5e0ca7),U64(0x7a76956c3eafb413),U64(0x3d5774a11d31ab39),U64(0x8a1b083821f40cb4),
     U64(0x7b4a38e32537df62),U64(0x950113646d1d6e03),U64(0x4da8979a41e8a9),U64(0x3bc36e078f7515d7),U64(0x5d0a12f27ad310d1),U64(0x7f9d1a2e1ebe1327),U64(0xda3a361b1c5157b1),U64(0xdcdd7d20903d0c25),U64(0x36833336d068f707),
     U64(0xce68341f79893389),U64(0xab9090168dd05f34),U64(0x43954b3252dc25e5),U64(0xb438c2b67f98e5e9),U64(0x10dcd78e3851a492),U64(0xdbc27ab5447822bf),U64(0x9b3cdb65f82ca382),U64(0xb67b7896167b4c84),U64(0xbfced1b048eac50),
     U64(0xa9119b60369ffebd),U64(0x1fff7ac8904bf45),U64(0xac12fb171817eee7),U64(0xaf08da9177dda93d),U64(0x1b0cab936e65c744),U64(0xb559eb1d4e5e932),U64(0xc37b45b3f8d6f2ba),U64(0xc3a9dc228caac9e9),U64(0xf3b8b6675a6507ff),
     U64(0x9fc477de4ed681da),U64(0x67378d8eccef96cb),U64(0x6dd856d94d259236),U64(0xa319ce15b0b4db31),U64(0x73973751f12dd5e),U64(0x8a8e849eb32781a5),U64(0xe1925c71285279f5),U64(0x74c04bf1790c0efe),U64(0x4dda48153c94938a),
     U64(0x9d266d6a1cc0542c),U64(0x7440fb816508c4fe),U64(0x13328503df48229f),U64(0xd6bf7baee43cac40),U64(0x4838d65f6ef6748f),U64(0x1e152328f3318dea),U64(0x8f8419a348f296bf),U64(0x72c8834a5957b511),U64(0xd7a023a73260b45c),
     U64(0x94ebc8abcfb56dae),U64(0x9fc10d0f989993e0),U64(0xde68a2355b93cae6),U64(0xa44cfe79ae538bbe),U64(0x9d1d84fcce371425),U64(0x51d2b1ab2ddfb636),U64(0x2fd7e4b9e72cd38c),U64(0x65ca5b96b7552210),U64(0xdd69a0d8ab3b546d),
     U64(0x604d51b25fbf70e2),U64(0x73aa8a564fb7ac9e),U64(0x1a8c1e992b941148),U64(0xaac40a273d9bea0),U64(0x764dbeae7fa4f3a6),U64(0x1e99b96e70a9be8b),U64(0x2c5e9deb57ef4743),U64(0x3a938fee32d29981),U64(0x26e6db8ffdf5adfe),
     U64(0x469356c54ec9f9d),U64(0xc8763c5b8d1908c),U64(0x3f6c6af859d80055),U64(0x7f7cc39420a3a545),U64(0x9bfb227ebdf4c5ce),U64(0x89039d79d6fc5c5c),U64(0x8fe88b57305e2ab6),U64(0xa09e8c8c35ab96de),U64(0xfa7e393983325753)
	 },
	 {//
     U64(0x51ebdc4ab9ba3035),U64(0x5c82c505db9ab0fa),U64(0xfcf7fe8a3430b241),U64(0x3253a729b9ba3dde),U64(0x8c74c36881b3075),U64(0xb9bc6c87167c33e7),U64(0x7ef48f2b83024e20),U64(0x11d505d4c351bd7f),U64(0x6568fca92c76a243),
     U64(0x4de0b0f4f32a7b8),U64(0x96d69346cc37e5d),U64(0x42e240cb63689f2f),U64(0x6d2bdcdae2919661),U64(0x42880b0236e4d951),U64(0x5f0f4a5898171bb6),U64(0x39f890f579f92f88),U64(0x93c5b5f47356388b),U64(0x63dc359d8d231b78),
     U64(0xec16ca8aea98ad76),U64(0x5355f900c2a82dc7),U64(0x7fb9f855a997142),U64(0x5093417aa8a7ed5e),U64(0x7bcbc38da25a7f3c),U64(0x19fc8a768cf4b6d4),U64(0x637a7780decfc0d9),U64(0x8249a47aee0e41f7),U64(0x79ad69551e7d1e8),
     U64(0x14acbaf4777d5776),U64(0xf145b6beccdea195),U64(0xdabf2ac8201752fc),U64(0x24c3c94df9c8d3f6),U64(0xbb6e2924f03912ea),U64(0xce26c0b95c980d9),U64(0xa49cd132bfbf7cc4),U64(0xe99d662af4243939),U64(0x27e6ad7891165c3f),
     U64(0x8535f040b9744ff1),U64(0x54b3f4fa5f40d873),U64(0x72b12c32127fed2b),U64(0xee954d3c7b411f47),U64(0x9a85ac909a24eaa1),U64(0x70ac4cd9f04f21f5),U64(0xf9b89d3e99a075c2),U64(0x87b3e2b2b5c907b1),U64(0xa366e5b8c54f48b8), 
	 U64(0xdfd395339cdbf4a7),0,U64(0xef927dbcf00c20f2),0,U64(0x7b32f7d1e03680ec),0,U64(0xb9fd7620e7316243),0,U64(0x5a7e8a57db91b77),
	 U64(0xb5889c6e15630a75),0,U64(0x4a750a09ce9573f7),0,U64(0xcf464cec899a2f8a),0,U64(0xf538639ce705b824),0,U64(0x3c79a0ff5580ef7f),
     0,0,0,U64(0xede6c87f8477609d),U64(0x799e81f05bc93f31),U64(0x86536b8cf3428a8c),0,0,0,
	 0,0,0,U64(0x97d7374c60087b73),U64(0xa246637cff328532),U64(0x43fcae6cc0eba0),0,0,0,
	 0,0,0,U64(0x920e449535dd359e),U64(0x70eb093b15b290cc),U64(0x73a1921916591cbd),0,0,0
	 },
	 {//ʿ
      	0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,
        0,U64(0x56436c9fe1a1aa8d),0,0,0,0,0,U64(0xefac4b70633b8f81),0,
		0,0,0,0,0,0,0,0,0,
        U64(0xbb215798d45df7af),0,0,U64(0x45f20042f24f1768),U64(0x930f80f4e8eb7462),U64(0xff6712ffcfd75ea1),0,0,U64(0xae623fd67468aa70),
        
		0,0,0,0,U64(0x21f08570f420e565),0,0,0,0,
		0,0,U64(0xb415938d7da94e3c),U64(0x91b859e59ecb6350),0,U64(0x10cff333e0ed804a),U64(0x28aed140be0bb7dd),0,0

	 },
	 {
		 //
U64(0xd6b6d0ecc617c699),U64(0xdfea21ea9e7557e3),U64(0xb67c1fa481680af8),U64(0xca1e3785a9e724e5),U64(0x1cfc8bedd681639),U64(0xd18d8549d140caea),U64(0x4ed0fe7e9dc91335),U64(0xe4dbf0634473f5d2),U64(0x1761f93a44d5aefe),
U64(0x53898e4c3910da55),U64(0x734de8181f6ec39a),U64(0x2680b122baa28d97),U64(0x298af231c85bafab),U64(0x7983eed3740847d5),U64(0x66c1a2a1a60cd889),U64(0x9e17e49642a3e4c1),U64(0xedb454e7badc0805),U64(0x50b704cab602c329),
U64(0x4cc317fb9cddd023),U64(0x66b4835d9eafea22),U64(0x219b97e26ffc81bd),U64(0x261e4e4ca333a9d),U64(0x1fe2cca76517db90),U64(0xd7504dfa8816edbb),U64(0xb9571fa04dc089c8),U64(0x1ddc0325259b27de),U64(0xcf3f4688801eb9aa),
U64(0xf4f5d05c10cab243),U64(0x38b6525c21a42b0e),U64(0x36f60e2ba4fa6800),U64(0xeb3593803173e0ce),U64(0x9c4cd6257c5a3603),U64(0xaf0c317d32adaa8a),U64(0x258e5a80c7204c4b),U64(0x8b889d624d44885d),U64(0xf4d14597e660f855),
U64(0xd4347f66ec8941c3),U64(0xe699ed85b0dfb40d),U64(0x2472f6207c2d0484),U64(0xc2a1e7b5b459aeb5),U64(0xab4f6451cc1d45ec),U64(0x63767572ae3d6174),U64(0xa59e0bd11731a28),U64(0x116d0016cb948f09),U64(0x2cf9c8ca52f6e9f),
U64(0xb090a7560a968e3),U64(0xabeeddb2dde06ff1),U64(0x58efc10b6a2068d),U64(0xc6e57a78fbd986e0),U64(0x2eab8ca63ce802d7),U64(0x14a19564116f336),U64(0x7c0828dd624ec390),U64(0xd74bbe77e6116ac7),U64(0x804456af10f5fb53),
U64(0xebe9ea2adf4321c7),U64(0x3219a39ee587a30),U64(0x49787fef17af9924),U64(0xa1e9300cd8520548),U64(0x5b45e522e4b1b4ef),U64(0xb49c3b3995091a36),U64(0xd4490ad526f14431),U64(0x12a8f216af9418c2),U64(0x1f837cc7350524),
U64(0x1877b51e57a764d5),U64(0xa2853b80f17f58ee),U64(0x993e1de72d36d310),U64(0xb3598080ce64a656),U64(0x252f59cfd9f04bb),U64(0xd23c8e176d113600),U64(0x1bda0492e7e4586e),U64(0x21e0bd5026c619bf),U64(0x3b097adaf088f94e),
U64(0x8d14dedb30be846e),U64(0xf95cffa23af5f6f4),U64(0x3871700761b3f743),U64(0xca672b91e9e4fa16),U64(0x64c8e531bff53b55),U64(0x241260ed4ad1e87d),U64(0x106c09b972d2e822),U64(0x7fba195410e5ca30),U64(0x7884d9bc6cb569d8),
U64(0x647dfedcd894a29),U64(0x63573ff03e224774),U64(0x4fc8e956f91b123),U64(0x1db956e450275779),U64(0xb8d91274b9e9d4fb),U64(0xa2ebee47e2fbfce1),U64(0xd9f1f30ccd97fb09),U64(0xefed53d75fd64e6b),U64(0x2e6d02c36017f67f)
	 },
	 {//
U64(0xa9aa4d20db084e9b),U64(0xb64be8d8b25396c1),U64(0x70cb6af7c2d5bcf0),U64(0x98f076a4f7a2322e),U64(0xbf8447085e69b5f),U64(0x94c3251f6f90cf3),U64(0x3e003e616a6591e9),U64(0xb925a6cd421aff3),U64(0x61bdd1307c66e300),
U64(0xbf8d5108e27e0d48),U64(0x240ab57a8b888b20),U64(0xfc87614baf287e07),U64(0xef02cdd06ffdb432),U64(0xa1082c0466df6c0a),U64(0x8215e5771332c8),U64(0xd39bb9c3a48db6cf),U64(0x2738259634305c14),U64(0x61cf4f94c97df93d),
U64(0x1b6baca2ae4e125b),U64(0x758f450c88572e0b),U64(0x959f587d507a8359),U64(0xb063e962e045f54d),U64(0x60e8ed72c0dff5d1),U64(0x7b64978555326f9f),U64(0xfd080d236da814ba),U64(0x8c90fd9b83f4558),U64(0x106f72fe81e2c590),
U64(0x7976033a39f7d952),U64(0xa4ec0132764ca04b),U64(0x733ea705fae4fa77),U64(0xb4d8f77bc3e56167),U64(0x9e21f4f93b33fd9),U64(0x9d765e419fb69f6d),U64(0xd30c088ba61ea5ef),U64(0x5d94337fbfaf7f5b),U64(0x1a4e4822eb4d7a59),
U64(0x6ffe73e81b637fb3),U64(0xddf957bc36d8b9ca),U64(0x64d0e29eea8838b3),U64(0x8dd9bdfd96b9f63),U64(0x87e79e5a57d1d13),U64(0xe328e230e3e2b3fb),U64(0x1c2559e3f0946be),U64(0x720bf5f26f4d2eaa),U64(0xb0774d261cc609db),
U64(0x443f64ec5a371195),U64(0x4112cf68649a260e),U64(0xd813f2fab7f5c5ca),U64(0x660d3257380841ee),U64(0x59ac2c7873f910a3),U64(0xe846963877671a17),U64(0x93b633abfa3469f8),U64(0xc0c0f5a6ef4cdcf),U64(0xcaf21ecd4377b28c),
U64(0x57277707199b8175),U64(0x506c11b9d90e8b1d),U64(0xd83cc2687a19255f),U64(0x4a29c6465a314cd1),U64(0xed2df21216235097),U64(0xb5635c95ff7296e2),U64(0x22af003ab672e811),U64(0x52e762596bf68235),U64(0x9aeba33ac6ecc6b0),
U64(0x944f6de09134dfb6),U64(0x6c47bec883a7de39),U64(0x6ad047c430a12104),U64(0xa5b1cfdba0ab4067),U64(0x7c45d833aff07862),U64(0x5092ef95a16da0b),U64(0x9338e69c52b8e7b),U64(0x455a4b4cfe30e3f5),U64(0x6b02e63195ad0cf8),
U64(0x6b17b224bad6bf27),U64(0xd1e0ccd25bb9c169),U64(0xde0c89a556b9ae70),U64(0x50065e535a213cf6),U64(0x9c1169fa2777b874),U64(0x78edefd694af1eed),U64(0x6dc93d9526a50e68),U64(0xee97f453f06791ed),U64(0x32ab0edb696703d3),
U64(0x3a6853c7e70757a7),U64(0x31865ced6120f37d),U64(0x67fef95d92607890),U64(0x1f2b1d1f15f6dc9c),U64(0xb69e38a8965c6b65),U64(0xaa9119ff184cccf4),U64(0xf43c732873f24c13),U64(0xfb4a3d794a9a80d2),U64(0x3550c2321fd6109c)
	 },
{//
U64(0x371f77e76bb8417e),U64(0x6bfa9aae5ec05779),U64(0xcd04f3ff1a4778),U64(0xe327352264480ca),U64(0x9f91508bffcfc14a),U64(0x49a7f4161a9e60),U64(0xfcb6be43a9f2fe9b),U64(0x8de8a1c7797da9b),U64(0x8f9887e678735a1),
U64(0xb5b4071dbfc73a66),U64(0x230e343dfba08d33),U64(0x43ed7f5afae657d),U64(0x3a88a0fbbcb05c63),U64(0x21874b8b4d2dbc4f),U64(0x1bdea12e35f6a8c9),U64(0x53c065c6c8e63528),U64(0xe34a1d25e7a8d6b),U64(0xd6b04d3b7651dd7e),
U64(0x5e90277e7cb39e2d),U64(0x2c046f2262dc67d),U64(0xb10bb459132d0a26),U64(0x3fa9ddfb67e2f199),U64(0xe09b88e1914f7af),U64(0x10e8b35af3eeab37),U64(0x9eedeca8e272b933),U64(0xd4c718bc4ae8ae5f),U64(0x81536d601170fc20),
U64(0x91b534f885818a06),U64(0xec8177f83f900978),U64(0x190e714fada5156e),U64(0xb592bf39b0364963),U64(0x89c350c893ae7dc1),U64(0xac042e70f8b383f2),U64(0xb49b52e587a1ee60),U64(0xfb152fe3ff26da89),U64(0x3e666e6f69ae2c15),
U64(0x3b544ebe544c19f9),U64(0xe805a1e290cf2456),U64(0x24b33c9d7ed25117),U64(0xe74733427b72f0c1),U64(0xa804d18b7097475),U64(0x57e3306d881edb4f),U64(0x4ae7d6a36eb5dbcb),U64(0x2d8d5432157064c8),U64(0xd1e649de1e7f268b),
U64(0x8a328a1cedfe552c),U64(0x7a3aec79624c7da),U64(0x84547ddc3e203c94),U64(0x990a98fd5071d263),U64(0x1a4ff12616eefc89),U64(0xf6f7fd1431714200),U64(0x30c05b1ba332f41c),U64(0x8d2636b81555a786),U64(0x46c9feb55d120902),
U64(0xccec0a73b49c9921),U64(0x4e9d2827355fc492),U64(0x19ebb029435dcb0f),U64(0x4659d2b743848a2c),U64(0x963ef2c96b33be31),U64(0x74f85198b05a2e7d),U64(0x5a0f544dd2b1fb18),U64(0x3727073c2e134b1),U64(0xc7f6aa2de59aea61),
U64(0x352787baa0d7c22f),U64(0x9853eab63b5e0b35),U64(0xabbdcdd7ed5c0860),U64(0xcf05daf5ac8d77b0),U64(0x49cad48cebf4a71e),U64(0x7a4c10ec2158c4a6),U64(0xd9e92aa246bf719e),U64(0x13ae978d9fe5557),U64(0x730499af921549ff),
U64(0x4e4b705b92903ba4),U64(0xff577222c14f0a3a),U64(0x55b6344cf97aafae),U64(0xb862225b55b6960),U64(0xcac09afbddd2cdb4),U64(0xdaf8e9829fe96b5f),U64(0xb5fdfc5d3132c498),U64(0x310cb380db6f7503),U64(0xe87fbb46217a360e),
U64(0x2102ae466ebb1148),U64(0xf8549e1a3aa5e00d),U64(0x7a69afdcc42261a),U64(0xc4c118bfe78feaae),U64(0xf9f4892ed96bd438),U64(0x1af3dbe25d8f45da),U64(0xf5b4b0b0d2deeeb4),U64(0x962aceefa82e1c84),U64(0x46e3ecaaf453ce9)
}
};
*/
   //U64(0xc5cc1d89724fa456),
     //U64(0x5648f680f11a2741),U64(0x2d255069f0b7dab3),U64(0x9bc5a38ef729abd4),U64(0xef2f05438f6a2bc),U64(0xaf2042f5cc5c2858),U64(0x480412bab7f5be2a),U64(0xaef3af4a563dfe43),U64(0x19afe59ae451497f),U64(0x52593803dff1e840),
     //U64(0xf4f076e65f2ce6f0),U64(0x11379625747d5af3),U64(0xbce5d2248682c115),U64(0x9da4243de836994f),U64(0x66f70b33fe09017),U64(0x4dc4de189b671a1c),U64(0x51039ab7712457c3),U64(0xc07a3f80c31fb4b4),U64(0xb46ee9c5e64a6e7c),
     //U64(0xb3819a42abe61c87),U64(0x21a007933a522a20),U64(0x2df16f761598aa4f),U64(0x763c4a1371b368fd),U64(0xf793c4672e086a0),U64(0xd7288e012aeb8d31),U64(0xde336a2a4bc1c44b),U64(0xbf692b38d079f23),U64(0x2c604a7a177326b3)

//U64(0x964781ce734b3c84),U64(0x9c2ed44081ce5fbd),U64(0x522e23f3925e319e),U64(0x177e00f9fc32f791),U64(0x2bc60a63a6f3b3f2),U64(0x222bbfae61725606),U64(0x486289ddcc3d6780),U64(0x7dc7785b8efdfc80),
//U64(0x8af38731c02ba980),U64(0x1fab64ea29a2ddf7),U64(0xe4d9429322cd065a),U64(0x9da058c67844f20c),U64(0x24c0e332b70019b0),U64(0x233003b5a6cfe6ad),U64(0xd586bd01c5c217f6),U64(0x5e5637885f29bc2b),U64(0x7eba726d8c94094b),
//U64(0xa56a5f0bfe39272),U64(0xd79476a84ee20d06),U64(0x9e4c1269baa4bf37),U64(0x17efee45b0dee640),U64(0x1d95b0a5fcf90bc6),U64(0x93cbe0b699c2585d),U64(0x65fa4f227a2b6d79),U64(0xd5f9e858292504d5),U64(0xc2b5a03f71471a6f),
//U64(0x59300222b4561e00),U64(0xce2f8642ca0712dc),U64(0x7ca9723fbb2e8988),U64(0x2785338347f2ba08),U64(0xc61bb3a141e50e8c),U64(0x150f361dab9dec26),U64(0x9f6a419d382595f4),U64(0x64a53dc924fe7ac9),U64(0x142de49fff7a7c3d),
//U64(0xc335248857fa9e7),U64(0xa9c32d5eae45305),U64(0xe6c42178c4bbb92e),U64(0x71f1ce2490d20b07),U64(0xf1bcc3d275afe51a),U64(0xe728e8c83c334074),U64(0x96fbf83a12884624),U64(0x81a1549fd6573da5),U64(0x5fa7867caf35e149),
//U64(0x56986e2ef3ed091b),U64(0x917f1dd5f8886c61),U64(0xd20d8c88c8ffe65f),U64(0x31d71dce64b2c310),U64(0xf165b587df898190),U64(0xa57e6339dd2cf3a0),U64(0x1ef6e6dbb1961ec9),U64(0x70cc73d9bc26e24),U64(0xe21a6b35df0c3ad7),
//U64(0x3a93d8b2806962),U64(0x1c99ded33cb890a1),U64(0xcf3145deadd4289),U64(0xd0e4427a5514fb72),U64(0x77c621cc9fb3a483),U64(0x67a34dac4356550b),U64(0xf8d626aaaf278509),