/*! \file ucci.h
@brief UCCIͨѶģ飨ṩѭGPLɣ

ϢƳ ѧѧϵ滯ѧʵ E-mailwebmaster at elephantbase dot net 
*/

#ifndef UCCI_H
#define UCCI_H

#include "../utility/bool.h"
const int UCCI_MAX_DEPTH = 32; // UCCI˼ļ

// UCCIָйؼйصѡ
enum UcciOptionEnum {
  UCCI_OPTION_NONE, UCCI_OPTION_BATCH, UCCI_OPTION_DEBUG, UCCI_OPTION_USEMILLISEC, UCCI_OPTION_BOOKFILES, UCCI_OPTION_HASHSIZE, UCCI_OPTION_THREADS, UCCI_OPTION_DRAWMOVES,
  UCCI_OPTION_REPETITION, UCCI_OPTION_PRUNING, UCCI_OPTION_KNOWLEDGE, UCCI_OPTION_SELECTIVITY, UCCI_OPTION_STYLE, UCCI_OPTION_LOADBOOK
}; // uo, "setoption"ָѡ
enum UcciRepetEnum {
  UCCI_REPET_ALWAYSDRAW, UCCI_REPET_CHECKBAN, UCCI_REPET_ASIANRULE, UCCI_REPET_CHINESERULE
}; // ur
enum UcciGradeEnum {
  UCCI_GRADE_NONE, UCCI_GRADE_SMALL, UCCI_GRADE_MEDIUM, UCCI_GRADE_LARGE
}; // ug
enum UcciStyleEnum {
  UCCI_STYLE_SOLID, UCCI_STYLE_NORMAL, UCCI_STYLE_RISKY
}; // us, ѡstyle趨ֵ
enum UcciTimeEnum {
  UCCI_TIME_DEPTH, UCCI_TIME_MOVE, UCCI_TIME_INC
}; // ut, "go"ָָʱģʽֱǹ̶(൱Ϊ"c_MaxDepth")ʱ(ڱɼ)ͼʱ(ʣʱ٣ⲽӼ)
enum UcciCommEnum {
  UCCI_COMM_NONE, UCCI_COMM_UCCI, UCCI_COMM_ISREADY, UCCI_COMM_PONDERHIT, UCCI_COMM_STOP, UCCI_COMM_SETOPTION, UCCI_COMM_POSITION, UCCI_COMM_BANMOVES, UCCI_COMM_GO, UCCI_COMM_GOPONDER, UCCI_COMM_QUIT
}; // uce, UCCIָ

///UCCIͨѶģ飨ṩѭGPLɣ 
/*!
ֱʹUCCIԱṩͨͨѶģ飨ѭGPLɣ

ʵֺ͹˵μhttp://www.elephantbase.net/protocol/cchess_ucci.htm
*/
// UCCIָԽͳĽṹ
union UcciCommStruct {

  /* ɵõϢUCCIָֻ4
   *
   * 1. "setoption"ָݵϢʺ"UCCI_COMM_SETOPTION"ָ
   *    "setoption"ָ趨ѡܵϢСѡ͡͡ѡֵ
   *    磬"setoption batch on"ѡ;"UCCI_OPTION_DEBUG"ֵ(Value.bCheck)"TRUE"
   */
  struct {
    UcciOptionEnum uoType;   // ѡ
    union {                  // ѡֵ
      int nSpin;             // "spin"͵ѡֵ
      Bool bCheck;           // "check"͵ѡֵ
      UcciRepetEnum urRepet; // "combo"͵ѡ"repetition"ֵ
      UcciGradeEnum ugGrade; // "combo"͵ѡ"pruning""knowledge""selectivity"ֵ
      UcciStyleEnum usStyle; // "combo"͵ѡ"style"ֵ
      const char *szString;  // "string"͵ѡֵ
    } Value;                 // "button"͵ѡûֵ
  } Option;

  /* 2. "position"ָݵϢʺ"e_CommPosition"ָ
   *    "position"ָþ棬ʼͬŷɵľ
   *    磬position startpos moves h2e2 h9g8FEN"startpos"FENŷ(MoveNum)2
   */
  struct {
    const char *szFenStr; // FEN("startpos")ҲɽתFEN
    int nMoveNum;         // ŷ
    long *lpdwCoordList;  // ŷָ"IdleLine()"еһ̬飬԰"CoordList"
  } Position;

  /* 3. "banmoves"ָݵϢʺ"e_CommBanMoves"ָ
   *    "banmoves"ָýֹŷݽṹʱ"position"ָĺŷûFEN
   */
  struct {
    int nMoveNum;
    long *lpdwCoordList;
  } BanMoves;

  /* 4. "go"ָݵϢʺ"e_CommGo""e_CommGoPonder"ָ
   *    "go"ָ˼()ͬʱ趨˼ģʽ̶ȡʱƻǼʱ
   */
  struct {
    UcciTimeEnum utMode; // ˼ģʽ
    union {          
      int nDepth, nTime; 
    } DepthTime; // ǹ̶ȣʾ()޶ʱ䣬ʾʱ()
    union {
      int nMovesToGo, nIncrement;
    } TimeMode;  // Ǽʱƣ޶ʱҪ߶ٲ壬ʱƣʾò޶ʱӶ
  } Search;
}; // ucs

// UCCIָڲͬ
UcciCommEnum BootLine(void);                                    // UCCIĵһָֻ"ucci"
UcciCommEnum IdleLine(UcciCommStruct &ucsCommand, Bool bDebug); // ʱָ
UcciCommEnum BusyLine(Bool bDebug);                             // ˼ʱָֻ"stop""ponderhit"
void ExitLine(void);

#endif
