/*! \file searcher.h
@brief ࣨģ飩
*/

#ifndef SERCHER_H
#define SERCHER_H

#include <stdio.h>
#include <time.h>
#include "../utility/bool.h"
#include "constant.h"
#include "board.h"
#include "movement.h"
#include "movemaker.h"
#include "evaluation.h"
#include "openbook.h"
//#include "hashnum.h"

/// 
static int searchDepth;

///ŷ 
static Movement allmoves[MAX_SEARCH_DEPTH + 1][SEARCH_WIDTH];
///̬Ŀŷ 
static Movement qsmoves[MAX_QUIES_DEPTH + 1][SEARCH_WIDTH];

///ǰŷ
static Movement best; 
///ϴŷ
static Movement lastbest; 
///ǰμŷǰλѭ棩
static Movement better;
///ϴμŷǰλѭ棩
static Movement lastbetter;
///ǰŷǰλѭ棩
static Movement good;
///ϴŷǰλѭ棩
static Movement lastgood;

///ʼʱ 
static time_t startTime;

///ʷŷ¼
/*!¼ţҲǿֵܳѭ 
   ΪѭҪик͡ 
   ʼֵΪܵŷԿֵ⴦ 
*/
static long history[2][4] = {{0, 1, 2, 3}, {0, 1, 2, 3}};

///ϣʷ¼
static HASHNUM hashlink[MAX_SEARCH_DEPTH];

///̬Ĺϣʷ¼
static HASHNUM qshashlink[MAX_QUIES_DEPTH];

///õһվ· 
static Movement trace[MAX_SEARCH_DEPTH];
///̬õһվ· 
static Movement qstrace[MAX_QUIES_DEPTH];

///ࣨģ飩
/*!
ϵÿһڵ㶼һ棬ÿһĽڵ㶼丸ڵпŷγɵġżڵֱʾ˫ľ档ҪڶҶӽڵѡһѵľ棬ӶƵǰŷΪԼѡ 

ٶȿִ֦Principal Variable Search 
*/  
class Searcher
{
public:
    ///õһŷ 
    static void GetBestmove(Board & cur, PLAYER who);
    ///жǷʤ 
    inline static Bool GameOver(Board & cur);
private:
    ///PVSŷ 
    static int PVSearch(Board & cur, int depth, PLAYER who, int alpha, int beta);
    ///̬ʹãҶӽڵ㴦ã
    static int QuiesSearch(Board & cur, int depth, PLAYER who, int alpha, int beta);
};

#endif
