/*! \file board.h
@brief ̱ʾ
*/

#ifndef BOARD_H
#define BOARD_H

#include <string.h>
#include "../utility/bool.h"
#include "constant.h"
#include "movement.h"
#include "hashnum.h"

///̱ʾ
/*!
㷨Чʵֵķ㣬ǲõĿǰеһ"1616̱ʾ"ʵʱΪ㷽㣬óΪ256һάʾַĴ洢ԭ910Ķάһ£1616мһʾ̡ĺôһСֱΪ0x100x01øλʾ̵ı仯910Ķά˳910öࣻһΧһȦ"ڱ"Աʹô߽⣬Զֹ̱߽߳硣

̱ʾֻ"""һֵ˭ˣ"ǱҪϢݳԱȫΪ˷ģĿټá¼˧λÿŷģпٵ֪ĳһŷǷɽ˧棻¼ǰZobrist̵Ĺϣʾڿֿпټһ档
*/
class Board
{
public:
    /*----------Ա----------*/
    ///һֵ˭ˣ 
    PLAYER player;
    ///һӿе߷Ŀ
    /*!һԪ壬İӴ˳УڷҲǾֵ1~7 
       ִ MoveMaker::Make  
    */
    int numOfMove[8];
    ///
    /*!ʹ16*16ʾڿŷͬʱֹ̱߽߳硣 
       οhttp://www.elephantbase.net/computer/eleeye_struct.htm
    */
    CHESSMAN position[256];
    ///ǰ Zobrist  
    HASHNUM zobrist;
    ///ǰӸжǿ֣о֣о
    int numOfChess;
    ///¼˧λ 
    BDPOINT kingpos[2];
    ///¼õ˾һŷ 
    /*!ִֻ Board::AddMovement ֮壬Ҳ Board::DelMovement ݡ
    */
    Movement lastmove;
    ///˫ûгӵ岽غ 
    int non_eat_steps;
    ///ǰĻغ
    int bouts;
    /*----------Ա----------*/
    ///ĬϹ캯ݲʹ 
    Board();
    ///FEN̵Ĺ캯
    Board(const char * fen, int nMoveNum, long * lpdwCoordList);
    ///FEN
    /*!FENμhttp://www.elephantbase.net/protocol/cchess_fen.htm
    */ 
    void FromFen(const char * fen, int nMoveNum, long * lpdwCoordList);
    ///һŷı
    void AddMovement(const Movement & move); 
    ///ɾһŷı
    void DelMovement(const Movement & move); 
    ///֤һ4ֽŷִ硰h0i2ڱǷ
    /*!ֹֻ֤ӺϷԣ֤Ϸԡ
       ʽμhttp://www.elephantbase.net/protocol/cchess_move.htm 
    */
    Bool CanGo(const char * str); 
private:
    /*----------˽к----------*/
    /// 
    void ClearBoard();
};

#endif
